package org.gtreimagined.tesseract.api.fabric.wrapper;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;
import org.gtreimagined.tesseract.TesseractConfig;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;

public interface IEnergyHandlerStorage extends EnergyStorage {
    /**
     * Team Reborn EnergyStorage Implementations
     **/
    @Override
    default long insert(long maxReceive, TransactionContext context) {
        long euToInsert = (long) (maxReceive / TesseractConfig.EU_TO_TRE_RATIO.get());
        long inserted = getEnergyHandler().insertEu(euToInsert, true);
        context.addCloseCallback((t, r) -> {
            if (r.wasCommitted()){
                getEnergyHandler().insertEu(inserted, false);
            }
        });
        return (long) (inserted * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    @Override
    default long extract(long maxExtract, TransactionContext context) {
        long euToExtract = (long) (maxExtract / TesseractConfig.EU_TO_TRE_RATIO.get());
        long extracted = getEnergyHandler().extractEu(euToExtract, true);
        context.addCloseCallback((t, r) -> {
            if (r.wasCommitted()){
                getEnergyHandler().extractEu(euToExtract, false);
            }
        });
        return extracted;
    }

    @Override
    default long getAmount() {
        return (long) (getEnergyHandler().getEnergy() * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    @Override
    default long getCapacity() {
        return (long) (getEnergyHandler().getCapacity() * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    @Override
    default boolean supportsInsertion() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && getEnergyHandler().canInput();
    }

    @Override
    default boolean supportsExtraction() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && getEnergyHandler().canOutput();
    }

    IEnergyHandler getEnergyHandler();
}
