package org.gtreimagined.tesseract.api.fabric.wrapper;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.api.energy.EnergyMoveable;
import aztech.modern_industrialization.compat.megane.holder.EnergyComponentHolder;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.gtreimagined.tesseract.api.eu.EUState;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;

public class EnergyMoveableWrapper implements IEnergyHandler {
    private final class_2586 blockEntity;
    private final EnergyMoveable storage;

    private final EUState state = new EUState(this);

    public EnergyMoveableWrapper(class_2586 blockEntity, EnergyMoveable storage) {
        this.storage = storage;
        this.blockEntity = blockEntity;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        if (storage instanceof EnergyExtractable extractable && extractable.canExtract(getTier(voltage))){
            return extractable.extractEnergy(voltage, simulate ? Simulation.SIMULATE : Simulation.ACT);
        }
        return 0;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        if (storage instanceof EnergyInsertable insertable && insertable.canInsert(getTier(voltage))){
            return insertable.insertEnergy(voltage, simulate ? Simulation.SIMULATE : Simulation.ACT);
        }
        return 0;
    }

    public CableTier getTier(long tier){
        if (tier <= 32){
            return CableTier.LV;
        } else if (tier <= 128){
            return CableTier.MV;
        } else if (tier <= 1024){
            return CableTier.HV;
        } else if (tier < 8192){
            return CableTier.EV;
        }
        return CableTier.SUPERCONDUCTOR;
    }

    @Override
    public long getEnergy() {
        if (blockEntity instanceof EnergyComponentHolder holder){
            return holder.getEnergyComponent().getEu();
        }
        return 0;
    }

    @Override
    public long getCapacity() {
        if (blockEntity instanceof EnergyComponentHolder holder){
            return holder.getEnergyComponent().getCapacity();
        }
        return 0;
    }

    @Override
    public long getOutputAmperage() {
        return 1;
    }

    @Override
    public long getOutputVoltage() {
        if (blockEntity instanceof IEnergyMoveableTiers tiers) return tiers.getOutputVoltage();
        return 32;
    }

    @Override
    public long getInputAmperage() {
        return 1;
    }

    @Override
    public long getInputVoltage() {
        if (blockEntity instanceof IEnergyMoveableTiers tiers) return tiers.getInputVoltage();
        return 32;
    }

    @Override
    public boolean canOutput() {
        return storage instanceof EnergyExtractable;
    }

    @Override
    public boolean canInput() {
        return storage instanceof EnergyInsertable;
    }

    @Override
    public boolean canInput(class_2350 dir) {
        return canInput();
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return canOutput();
    }

    @Override
    public EUState getState() {
        return state;
    }

    @Override
    public void tesseractTick() {
        getState().onTick();
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        return null;
    }

    @Override
    public void deserialize(class_2487 nbt) {

    }
}
