package org.gtreimagined.tesseract.api;

import com.google.common.collect.ImmutableList;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.RoutedNode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public interface INode<TSelf extends INode<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TElement extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid> & IConnectable, TNetwork extends INetwork<TNetwork, TElement, TSelf, TRoutingInfo, TGrid>, TGrid extends IGrid<TGrid, TElement, TSelf, TRoutingInfo, TNetwork>> extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid>, INotableElement<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, IConnectable {
    @Override
    default List<RoutedNode<TSelf, TRoutingInfo>> getRoutedNeighbours(){
        List<RoutedNode<TSelf, TRoutingInfo>> list = new ArrayList<>();
        if (!isActuallyNode()) return list;
        for (class_2350 direction : class_2350.values()) {
            if (isOutput(direction)){
                class_2586 source = getBlockEntity();
                if (source != null) {
                    addNeighbor(direction, source, list, List.of());
                }
            }
        }
        return list;
    }

    boolean isOutput(class_2350 direction);

    default void addNeighbor(class_2350 side, class_2586 from, List<RoutedNode<TSelf, TRoutingInfo>> list, List<TElement> pathSoFar){
        class_2586 neighbor = from.method_10997().method_8321(from.method_11016().method_10093(side));
        if (neighbor != null && getElementClass().isInstance(neighbor)) {
            TElement fromElement = getElementClass().cast(neighbor);
            TSelf self;
            if(getSelfClass().isInstance(neighbor) && (self = getSelfClass().cast(fromElement)).isActuallyNode()){
                if (pathSoFar.isEmpty()) {
                    return;
                }
                if (self.isOutput(side.method_10153())) return;
                TRoutingInfo routingInfo = createRoutingInfo(pathSoFar, side.method_10153());
                list.add(new RoutedNode<>(self, routingInfo));
            } else if (getElementClass().isInstance(neighbor)) {
                TElement element = getElementClass().cast(neighbor);
                if (fromElement.connects(side) && element.connects(side.method_10153()) && !pathSoFar.contains(element)){
                    for (class_2350 direction : class_2350.values()) {
                        if (direction != side.method_10153()){
                            addNeighbor(direction, neighbor, list, ImmutableList.<TElement>builder().addAll(pathSoFar).add(element).build());
                        }
                    }
                }
            }
        }
    }

    Class<TSelf> getSelfClass();

    Class<TElement> getElementClass();



    TRoutingInfo createRoutingInfo(List<TElement> pathSoFar, class_2350 side);
}
