/*
 * Decompiled with CFR 0.152.
 */
package tesseract.mixin.fabric;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import team.reborn.energy.api.base.SimpleBatteryItem;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.fabric.wrapper.ContainerItemContextWrapper;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.IEnergyHandlerItem;

@Mixin(value={SimpleItemEnergyStorageImpl.class})
public abstract class SimpleItemEnergyStorageImplMixin
implements IEnergyHandlerItem {
    @Shadow(remap=false)
    @Final
    private long maxInsert;
    @Shadow(remap=false)
    @Final
    private long maxExtract;
    @Shadow(remap=false)
    @Final
    private ContainerItemContext ctx;
    @Unique
    protected GTConsumer.State state = new GTConsumer.State(this);
    @Unique
    private TesseractItemContext tesseractContext;

    @Shadow(remap=false)
    public abstract long getAmount();

    @Shadow(remap=false)
    public abstract boolean supportsExtraction();

    @Shadow(remap=false)
    public abstract boolean supportsInsertion();

    @Override
    @Shadow(remap=false)
    public abstract long getCapacity();

    @Shadow(remap=false)
    public abstract long extract(long var1, TransactionContext var3);

    @Shadow(remap=false)
    public abstract long insert(long var1, TransactionContext var3);

    @Shadow(remap=false)
    protected abstract boolean trySetEnergy(long var1, long var3, TransactionContext var5);

    @Override
    public class_2487 serialize(class_2487 tag) {
        return new class_2487();
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        long toAdd = Math.min(voltage, this.getCapacity() - this.getAmount());
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = this.insert(toAdd, (TransactionContext)transaction);
            if (inserted > 0L) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        long toDrain = Math.min(voltage, this.getEnergy());
        try (Transaction transaction = Transaction.openOuter();){
            long extracted = this.extract(toDrain, (TransactionContext)transaction);
            if (extracted > 0L) {
                transaction.commit();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public long availableAmpsInput(long voltage) {
        long added = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            added = this.insert(voltage, (TransactionContext)transaction);
        }
        if (added == voltage) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public long getEnergy() {
        return this.getAmount();
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputVoltage() {
        return this.maxExtract;
    }

    @Override
    public long getInputAmperage() {
        return 2L;
    }

    @Override
    public long getInputVoltage() {
        return this.maxInsert;
    }

    @Override
    public boolean canOutput() {
        return this.supportsExtraction();
    }

    @Override
    public boolean canInput() {
        return this.supportsInsertion();
    }

    @Override
    public boolean canInput(class_2350 direction) {
        return this.supportsInsertion();
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return this.supportsExtraction();
    }

    @Override
    public GTConsumer.State getState() {
        return this.state;
    }

    @Override
    public void setEnergy(long energy) {
        if (energy < 0L) {
            return;
        }
        class_1799 newStack = this.ctx.getItemVariant().toStack((int)this.ctx.getAmount());
        SimpleBatteryItem.setStoredEnergyUnchecked((class_1799)newStack, (long)energy);
        this.getContainer().setItemStack(newStack);
    }

    @Override
    public void setCapacity(long capacity) {
    }

    @Override
    @NotNull
    public TesseractItemContext getContainer() {
        if (this.tesseractContext == null) {
            this.tesseractContext = new ContainerItemContextWrapper(this.ctx);
        }
        return this.tesseractContext;
    }
}

