/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph.traverse;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;
import tesseract.graph.INode;
import tesseract.graph.traverse.BFSearcher;

public class BFDivider {
    private final BFSearcher searcher;
    private final Long2IntOpenHashMap roots = new Long2IntOpenHashMap();
    private final LongLinkedOpenHashSet lookup = new LongLinkedOpenHashSet();

    public BFDivider(INode container) {
        this.searcher = new BFSearcher(container);
        this.roots.defaultReturnValue(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int divide(Consumer<LongSet> removed, Consumer<LongSet> rootProvider, Consumer<LongSet> split) {
        if (!this.lookup.isEmpty() || !this.roots.isEmpty()) {
            throw new ConcurrentModificationException("Attempted to run concurrent divide operations on the same BFDivider instance");
        }
        rootProvider.accept((LongSet)this.lookup);
        int bestCount = 0;
        int bestColor = 0;
        int currentColor = 0;
        try {
            LongListIterator longListIterator = this.lookup.iterator();
            while (longListIterator.hasNext()) {
                long root = (Long)longListIterator.next();
                int existingColor = this.roots.get(root);
                if (existingColor != this.roots.defaultReturnValue()) continue;
                int color = currentColor++;
                this.roots.put(root, color);
                LongLinkedOpenHashSet found = new LongLinkedOpenHashSet();
                this.searcher.search(root, arg_0 -> this.lambda$divide$0(color, (LongSet)found, arg_0), removed);
                if (found.size() > bestCount) {
                    bestCount = found.size();
                    bestColor = color;
                }
                split.accept((LongSet)found);
            }
        }
        finally {
            this.lookup.clear();
            this.roots.clear();
        }
        return bestColor;
    }

    private /* synthetic */ void lambda$divide$0(int color, LongSet found, long reached) {
        if (this.lookup.contains(reached)) {
            this.roots.put(reached, color);
        }
        found.add(reached);
    }
}

