/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph.traverse;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Set;
import net.minecraft.class_2350;
import tesseract.graph.Graph;
import tesseract.graph.INode;
import tesseract.util.Node;
import tesseract.util.Pos;

public class ASFinder {
    private Deque<Node> path;
    private final INode container;
    private final Deque<Node> open = new ArrayDeque<Node>();
    private final Set<Node> closed = new ObjectOpenHashSet();

    public ASFinder(INode container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deque<Node> traverse(long origin, long target) {
        if (!this.closed.isEmpty() || !this.open.isEmpty()) {
            throw new ConcurrentModificationException("Attempted to run concurrent search operations on the same ASFinder instance");
        }
        if (origin == target) {
            throw new IllegalStateException("ASFinder::traverse: Attempted to run traverse operation with invalid positions");
        }
        this.path = new ArrayDeque<Node>();
        try {
            Node start = new Node(origin, true);
            Node end = new Node(target, false);
            this.open.add(start);
            while (!this.open.isEmpty()) {
                Node current = this.getLowestF();
                if (current.equals(end)) {
                    this.retracePath(current);
                    break;
                }
                this.open.remove(current);
                this.closed.add(current);
                for (Node n : this.getNeighboringNodes(current, origin, target)) {
                    if (n == null) break;
                    if (this.closed.contains(n)) continue;
                    int score = current.getCost() + current.distanceTo(n);
                    if (this.open.contains(n)) {
                        if (score < n.getCost()) {
                            n.setCost(score);
                            n.setParent(current);
                        }
                    } else {
                        n.setCost(score);
                        n.setParent(current);
                        this.open.add(n);
                    }
                    n.setHeuristic(n.heuristic(end));
                    n.setFunction(n.getCost() + n.getHeuristic());
                }
            }
        }
        finally {
            this.closed.clear();
            this.open.clear();
        }
        return this.path;
    }

    public void retracePath(Node current) {
        Node temp = current;
        temp.setCrossroad(true);
        this.path.add(temp);
        while ((temp = current.getParent()) != null) {
            temp.setCrossroad(temp.isValid() || this.retraceNode(temp));
            this.path.add(temp);
            current = temp;
        }
    }

    public boolean retraceNode(Node current) {
        int connections = 0;
        for (class_2350 direction : Graph.DIRECTIONS) {
            long pos = current.offset(direction).asLong();
            if (!this.container.connects(pos, direction.method_10153())) continue;
            ++connections;
        }
        return connections > 2;
    }

    private Node getLowestF() {
        Node lowest = this.open.peek();
        for (Node n : this.open) {
            if (n.getFunction() >= lowest.getFunction()) continue;
            lowest = n;
        }
        assert (lowest != null);
        return lowest;
    }

    public Node[] getNeighboringNodes(Node current, long start, long end) {
        Node[] neighbors = new Node[6];
        int i = 0;
        for (class_2350 direction : Graph.DIRECTIONS) {
            long side = Pos.offset(current.asLong(), direction);
            if (!this.container.contains(side) || !this.container.connects(side, direction.method_10153())) continue;
            neighbors[i++] = new Node(side, direction.method_10153());
        }
        return neighbors;
    }
}

