/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2350;
import tesseract.api.Controller;
import tesseract.api.IConnectable;
import tesseract.graph.Cache;
import tesseract.graph.Grid;
import tesseract.graph.Group;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.util.CID;
import tesseract.util.Pos;

public class Graph<T, C extends IConnectable, N>
implements INode {
    public static final class_2350[] DIRECTIONS = class_2350.values();
    private final Int2ObjectMap<Group<T, C, N>> groups = new Int2ObjectLinkedOpenHashMap();
    private final Long2IntMap positions = new Long2IntLinkedOpenHashMap();
    private final Supplier<Controller<T, C, N>> controller;

    public Graph(Supplier<Controller<T, C, N>> controller) {
        this.positions.defaultReturnValue(Integer.MAX_VALUE);
        this.controller = controller;
    }

    @Override
    public boolean contains(long pos) {
        return this.positions.containsKey(pos);
    }

    @Override
    public boolean linked(long from, class_2350 towards, long to) {
        return this.positions.containsKey(from) && this.positions.containsKey(to) && this.positions.get(from) == this.positions.get(to);
    }

    @Override
    public boolean connects(long pos, class_2350 towards) {
        return this.contains(pos);
    }

    public int countGroups() {
        return this.groups.size();
    }

    public Int2ObjectMap<Group<T, C, N>> getGroups() {
        return Int2ObjectMaps.unmodifiable(this.groups);
    }

    public void addNode(NodeCache<N> cache) {
        if (cache.capCount() == 0) {
            return;
        }
        Group<T, C, N> group = this.add(cache.pos, () -> Group.singleNode(cache.pos, cache, this.controller.get()));
        if (group != null) {
            group.addNode(cache.pos, cache, this.controller.get());
        }
    }

    public void addConnector(long pos, Cache<C> connector) {
        Group<T, C, N> group;
        if (!this.contains(pos) && (group = this.add(pos, () -> Group.singleConnector(pos, connector, this.controller.get()))) != null) {
            group.addConnector(pos, connector, this.controller.get());
        }
    }

    public int size() {
        return this.positions.size();
    }

    private Group<T, C, N> add(long pos, Supplier<Group<T, C, N>> single) {
        IntSet mergers = this.getNeighboringGroups(pos);
        switch (mergers.size()) {
            case 0: {
                int id = CID.nextId();
                this.positions.put(pos, id);
                this.groups.put(id, single.get());
                return null;
            }
            case 1: {
                int id = mergers.iterator().nextInt();
                this.positions.put(pos, id);
                return (Group)this.groups.get(id);
            }
        }
        Merged<T, C, N> data = this.beginMerge(mergers);
        this.positions.put(pos, data.bestId);
        for (Group other : data.merged) {
            data.best.mergeWith(other, pos);
        }
        return data.best;
    }

    public boolean removeAt(long pos) {
        return this.removeInternal(pos);
    }

    private boolean removeInternal(long pos) {
        int id = this.positions.get(pos);
        if (id == Integer.MAX_VALUE) {
            return false;
        }
        Group group = (Group)this.groups.get(id);
        boolean ok = group.removeAt(pos, newGroup -> {
            int newId = CID.nextId();
            this.groups.put(newId, newGroup);
            LongIterator longIterator = newGroup.getNodes().keySet().iterator();
            while (longIterator.hasNext()) {
                long part = (Long)longIterator.next();
                this.positions.put(part, newId);
            }
            for (Grid grid : newGroup.getGrids().values()) {
                LongIterator longIterator2 = grid.getConnectors().keySet().iterator();
                while (longIterator2.hasNext()) {
                    long part = (Long)longIterator2.next();
                    this.positions.put(part, newId);
                }
            }
        });
        if (ok) {
            this.positions.remove(pos);
        }
        if (group.countBlocks() == 0) {
            this.groups.remove(id);
        }
        return ok;
    }

    public Group<T, C, N> getGroupAt(long pos) {
        int id = this.positions.get(pos);
        return id != Integer.MAX_VALUE ? (Group)this.groups.get(id) : null;
    }

    private Merged<T, C, N> beginMerge(IntSet mergers) {
        int bestId = mergers.iterator().nextInt();
        Group best = (Group)this.groups.get(bestId);
        int bestSize = best.countBlocks();
        IntIterator intIterator = mergers.iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            Group candidate = (Group)this.groups.get(id);
            int size = candidate.countBlocks();
            if (size <= bestSize) continue;
            best = candidate;
            bestId = id;
            bestSize = size;
        }
        ObjectArrayList mergeGroups = new ObjectArrayList(mergers.size() - 1);
        IntIterator intIterator2 = mergers.iterator();
        while (intIterator2.hasNext()) {
            int id = (Integer)intIterator2.next();
            if (id == bestId) continue;
            Group removed = (Group)this.groups.remove(id);
            for (long pos : removed.getBlocks()) {
                this.positions.put(pos, bestId);
            }
            mergeGroups.add(removed);
        }
        return new Merged(bestId, best, mergeGroups);
    }

    private IntSet getNeighboringGroups(long pos) {
        IntLinkedOpenHashSet neighbors = new IntLinkedOpenHashSet(6);
        Pos position = new Pos(pos);
        for (class_2350 direction : DIRECTIONS) {
            long side = position.offset(direction).asLong();
            int id = this.positions.get(side);
            if (id == Integer.MAX_VALUE) continue;
            neighbors.add(id);
        }
        return neighbors;
    }

    private record Merged<T, C extends IConnectable, N>(int bestId, Group<T, C, N> best, List<Group<T, C, N>> merged) {
    }

    public static interface INodeGetter<T> {
        public T get(long var1, class_2350 var3, Runnable var4);
    }
}

