/*
 * Decompiled with CFR 0.152.
 */
package tesseract.fabric;

import java.util.function.BiFunction;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import team.reborn.energy.api.EnergyStorage;
import tesseract.Tesseract;
import tesseract.TesseractConfig;
import tesseract.api.GraphWrapper;
import tesseract.api.fabric.TesseractLookups;
import tesseract.api.fabric.wrapper.ContainerItemContextWrapper;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyItem;

public class TesseractImpl
extends Tesseract
implements ModInitializer {
    private static void onWorldUnload(MinecraftServer server, class_3218 world) {
        if (world == null) {
            return;
        }
        GraphWrapper.getWrappers().forEach(g -> g.removeWorld((class_1937)world));
        firstTick.remove(world);
    }

    private static void onEndTick(class_3218 l) {
        if (!TesseractImpl.hadFirstTick((class_1936)l)) {
            firstTick.add(l);
            GraphWrapper.getWrappers().forEach(t -> t.onFirstTick((class_1937)l));
        }
        if (l.method_8510() % 1000L == 0L) {
            GraphWrapper.getWrappers().forEach(GraphWrapper::healthCheck);
        }
    }

    private static void onStartTick(class_3218 l) {
        if (!TesseractImpl.hadFirstTick((class_1936)l)) {
            firstTick.add(l);
            GraphWrapper.getWrappers().forEach(t -> t.onFirstTick((class_1937)l));
        }
        GraphWrapper.getWrappers().forEach(t -> t.tick((class_1937)l));
        if (l.method_8510() % 1000L == 0L) {
            GraphWrapper.getWrappers().forEach(GraphWrapper::healthCheck);
        }
    }

    private static void onServerStopping(MinecraftServer s) {
        firstTick.clear();
        GraphWrapper.getWrappers().forEach(GraphWrapper::clear);
    }

    public void onInitialize() {
        Tesseract.init();
        TesseractConfig.createConfig();
        ServerLifecycleEvents.SERVER_STOPPING.register(TesseractImpl::onServerStopping);
        ServerTickEvents.START_WORLD_TICK.register(TesseractImpl::onStartTick);
        ServerTickEvents.END_WORLD_TICK.register(TesseractImpl::onEndTick);
        ServerWorldEvents.UNLOAD.register(TesseractImpl::onWorldUnload);
        TesseractLookups.ENERGY_HANDLER_ITEM.registerFallback((s, c) -> {
            IEnergyItem energyItem;
            ContainerItemContextWrapper context = new ContainerItemContextWrapper((ContainerItemContext)c);
            class_1792 patt3411$temp = s.method_7909();
            if (patt3411$temp instanceof IEnergyItem && (energyItem = (IEnergyItem)patt3411$temp).canCreate(context)) {
                return energyItem.createEnergyHandler(context);
            }
            return null;
        });
    }

    public static void registerTREItem(BiFunction<class_1799, ContainerItemContext, IEnergyHandler> function, class_1792 type) {
        EnergyStorage.ITEM.registerForItems((stack, context) -> (EnergyStorage)function.apply(stack, (ContainerItemContext)context), new class_1935[]{type});
    }
}

