/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fabric.wrapper;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;
import tesseract.TesseractConfig;
import tesseract.api.gt.IEnergyHandler;

public interface IEnergyHandlerStorage
extends EnergyStorage {
    default public long insert(long maxReceive, TransactionContext context) {
        long euToInsert = (long)((double)maxReceive / TesseractConfig.EU_TO_TRE_RATIO.get());
        long inserted = this.getEnergyHandler().insertEu(euToInsert, true);
        context.addCloseCallback((t, r) -> {
            if (r.wasCommitted()) {
                this.getEnergyHandler().insertEu(inserted, false);
            }
        });
        return (long)((double)inserted * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    default public long extract(long maxExtract, TransactionContext context) {
        long euToExtract = (long)((double)maxExtract / TesseractConfig.EU_TO_TRE_RATIO.get());
        long extracted = this.getEnergyHandler().extractEu(euToExtract, true);
        context.addCloseCallback((t, r) -> {
            if (r.wasCommitted()) {
                this.getEnergyHandler().extractEu(euToExtract, false);
            }
        });
        return extracted;
    }

    default public long getAmount() {
        return (long)((double)this.getEnergyHandler().getEnergy() * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    default public long getCapacity() {
        return (long)((double)this.getEnergyHandler().getCapacity() * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    default public boolean supportsInsertion() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && this.getEnergyHandler().canInput();
    }

    default public boolean supportsExtraction() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && this.getEnergyHandler().canOutput();
    }

    public IEnergyHandler getEnergyHandler();
}

