package tesseract.fabric;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import tesseract.TesseractCapUtils;
import tesseract.TesseractConfig;
import tesseract.api.fabric.TesseractLookups;
import tesseract.api.fabric.wrapper.*;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.heat.IHeatHandler;

import java.util.Optional;

@SuppressWarnings("UnstableApiUsage")
public class TesseractCapUtilsImpl implements TesseractCapUtils {
    @Override
    public Optional<IEnergyHandlerItem> getEnergyHandlerItem(class_1799 stack){
        IEnergyHandlerItem energyHandler = ContainerItemContext.withConstant(stack).find(TesseractLookups.ENERGY_HANDLER_ITEM);
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IEnergyHandlerItem> getWrappedEnergyHandlerItem(class_1799 stack){
        IEnergyHandlerItem energyHandler = ContainerItemContext.withConstant(stack).find(TesseractLookups.ENERGY_HANDLER_ITEM);
        if (energyHandler == null){
            EnergyStorage storage = ContainerItemContext.withConstant(stack).find(EnergyStorage.ITEM);
            if (storage instanceof IEnergyHandlerItem e){
                energyHandler = e;
            }
        }
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IEnergyHandler> getEnergyHandler(@NotNull class_2586 entity, class_2350 side){
        IEnergyHandler energyHandler = TesseractLookups.ENERGY_HANDLER_SIDED.find(entity.method_10997(), entity.method_11016(), entity.method_11010(), entity, side);
        if (energyHandler == null) {
            energyHandler = getEnergyStorage(entity, side);
        }
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IHeatHandler> getHeatHandler(class_2586 entity, class_2350 side){
        IHeatHandler heatHandler = TesseractLookups.HEAT_HANDLER_SIDED.find(entity.method_10997(), entity.method_11016(), entity.method_11010(), entity, side);
        return Optional.ofNullable(heatHandler);
    }

    private IEnergyHandler getEnergyStorage(class_2586 be, class_2350 direction){
        EnergyStorage storage = EnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, direction);
        if (storage == null) return null;
        if (storage instanceof IEnergyHandler moveable1) return moveable1;
        if (storage instanceof IEnergyHandlerStorage handlerStorage) return handlerStorage.getEnergyHandler();
        return new EnergyTileWrapper(be, storage);
    }
}
