package tesseract.controller;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import tesseract.api.ITickingController;
import tesseract.api.gt.GTController;
import tesseract.api.gt.IGTNode;
import tesseract.graph.Graph;
import tesseract.graph.INode;

public class Energy extends GTController {

    /**
     * Creates instance of the tesseract.controller.
     *
     * @param dim The dimension id.
     */
    public Energy(class_1937 dim, Graph.INodeGetter<IGTNode> node) {
        super(dim, node);
    }

    @Override
    public void onNodeOverVoltage(class_1937 w, long pos, long voltage) {
        Utils.createExplosion(w, class_2338.method_10092(pos), 4.0F, class_1937.class_7867.field_40889);
    }

    @Override
    public void onCableOverAmperage(class_1937 w, long pos, long amperage) {
        Utils.createFireAround(w, class_2338.method_10092(pos));
    }

    @Override
    public void onCableOverVoltage(class_1937 w, long pos, long voltage) {
        Utils.createFireAround(w, class_2338.method_10092(pos));
    }

    @Override
    public ITickingController clone(INode group) {
        return new Energy(dim, getter).set(group);
    }
}
