package tesseract.api.capability;

import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.gt.*;
import tesseract.graph.Graph;
import tesseract.util.Pos;

public class TesseractGTCapability<T extends class_2586 & IGTCable> extends TesseractBaseCapability<T> implements IEnergyHandler {

    private final IGTCable cable;
    private GTTransaction old;

    public TesseractGTCapability(T tile, class_2350 dir, boolean isNode, ITransactionModifier modifier) {
        super(tile, dir, isNode, modifier);
        this.cable = tile;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        if (this.isSending || (!simulate && old == null)) return 0;
        this.isSending = true;
        if (!simulate) {
            old.commit();
        } else {
            long pos = tile.method_11016().method_10063();
            GTTransaction transaction = new GTTransaction(voltage, t -> {});
            if (!this.isNode) {
                TesseractGraphWrappers.GT_ENERGY.getController(tile.method_10997(), pos).insert(pos, side, transaction, callback);
            } else {
                transferAroundPipe(transaction, pos);
            }
            this.old = transaction;
        }
        this.isSending = false;
        return voltage - old.eu;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        return 0;
    }

    private void transferAroundPipe(GTTransaction transaction, long pos) {
        boolean hasInserted = false;
        boolean lossAdded = false;
        for (class_2350 dir : Graph.DIRECTIONS) {
            if (dir == this.side || !this.tile.connects(dir)) continue;
            //First, perform cover modifications.
            class_2586 otherTile = tile.method_10997().method_8321(class_2338.method_10092(Pos.offset(pos, dir)));
            if (otherTile != null) {
                //Check the handler.
                var cap = TesseractCapUtils.INSTANCE.getEnergyHandler(otherTile, dir.method_10153());
                if (cap.isEmpty()) continue;
                //Perform insertion, and add to the transaction.
                var handler = cap.get();
                long loss = Math.round(cable.getLoss());
                if (hasInserted && !lossAdded){
                    transaction.addData(0, loss, 0, d -> {});
                    lossAdded = true;
                }

                long remainingEu = lossAdded ? transaction.eu : transaction.eu - loss;
                GTTransaction.TransferData data = new GTTransaction.TransferData(transaction, remainingEu, transaction.voltage).setLoss(cable.getLoss());
                if (this.callback.modify(data, dir, false, true) || this.callback.modify(data, side, true, true)){
                    continue;
                }
                if (data.getEu() < remainingEu) remainingEu = data.getEu();
                if (data.getLoss() > 0) remainingEu -= Math.round(data.getLoss());
                if (remainingEu <= 0) return;
                long inserted = handler.insertEu(remainingEu, true);
                if (inserted > 0){
                    transaction.addData(inserted, inserted, cable.getLoss(), t -> {
                        if (this.callback.modify(t, dir, false, false) || this.callback.modify(data, side, true, false)){
                            return;
                        }
                        handler.insertEu(t.getEu(), false);
                    });
                    if (transaction.voltage > this.cable.getVoltage()){
                        ((IGTEvent)TesseractGraphWrappers.GT_ENERGY.getController(tile.method_10997(), pos)).onCableOverVoltage(tile.method_10997(), pos, transaction.voltage);
                    }
                }
                if (transaction.eu == 0) break;
            }
        }
    }

    @Override
    public long getEnergy() {
        return 0;
    }

    @Override
    public long getCapacity() {
        return 0;
    }

    @Override
    public long availableAmpsInput(long voltage) {
        return Long.MAX_VALUE;
    }

    @Override
    public long availableAmpsOutput() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputVoltage() {
        return cable.getVoltage();
    }

    @Override
    public long getInputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getInputVoltage() {
        return cable.getVoltage();
    }

    @Override
    public boolean canOutput() {
        return true;
    }

    @Override
    public boolean canInput() {
        return true;
    }

    @Override
    public boolean canInput(class_2350 direction) {
        return true;
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return true;
    }

    @Override
    public GTConsumer.State getState() {
        return new GTConsumer.State(this);
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        return null;
    }

    @Override
    public void deserialize(class_2487 nbt) {

    }
}
