/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Deque;
import tesseract.api.IConnectable;
import tesseract.graph.Cache;
import tesseract.util.Node;

public class Path<C extends IConnectable> {
    private final Node origin;
    private final Node target;
    private final Long2ObjectMap<C> full = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectMap<C> cross = new Long2ObjectLinkedOpenHashMap();

    protected Path(Long2ObjectMap<Cache<C>> connectors, Deque<Node> path) {
        this.origin = path.pollLast();
        this.target = path.pollFirst();
        while (!path.isEmpty()) {
            Node node = path.removeLast();
            long pos = node.asLong();
            Cache cache = (Cache)connectors.get(pos);
            if (cache == null) continue;
            Object cable = cache.value();
            this.full.put(pos, cable);
            if (!node.isCrossroad()) continue;
            this.cross.put(pos, cable);
        }
    }

    public Node origin() {
        return this.origin;
    }

    public Node target() {
        return this.target;
    }

    public Long2ObjectMap<C> getFull() {
        return this.full;
    }

    public Long2ObjectMap<C> getCross() {
        return this.cross;
    }

    public boolean isEmpty() {
        return this.origin == null || this.target == null;
    }
}

