/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.gt;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import tesseract.api.Consumer;
import tesseract.api.gt.IGTCable;
import tesseract.api.gt.IGTNode;
import tesseract.graph.Path;

public class GTConsumer
extends Consumer<IGTCable, IGTNode> {
    private double loss;
    private long minVoltage = Integer.MAX_VALUE;
    private int minAmperage = Integer.MAX_VALUE;
    public static final Comparator<GTConsumer> COMPARATOR = (t1, t2) -> t1.getDistance() == t2.getDistance() ? Double.compare(t1.getLoss(), t2.getLoss()) : Integer.compare(t1.getDistance(), t2.getDistance());
    public final LongSet uninsulatedCables = new LongOpenHashSet();

    public GTConsumer(IGTNode consumer, IGTNode producer, Path<IGTCable> path) {
        super(consumer, producer, path);
        this.init();
    }

    public long getRequiredAmperage(long voltage) {
        return ((IGTNode)this.node).availableAmpsInput(voltage);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public double getLoss() {
        return this.loss;
    }

    public boolean canHandle(long voltage) {
        return this.minVoltage >= voltage;
    }

    public boolean canHandleAmp(long minAmperage) {
        return (long)this.minAmperage >= minAmperage;
    }

    public void copy(GTConsumer consumer) {
        this.loss = consumer.loss;
        this.full = consumer.full;
        this.cross = consumer.cross;
        this.minVoltage = consumer.minVoltage;
        this.minAmperage = consumer.minAmperage;
    }

    @Override
    protected void onConnectorCatch(long pos, IGTCable cable) {
        this.loss += cable.getLoss();
        this.minVoltage = Math.min(this.minVoltage, cable.getVoltage());
        this.minAmperage = Math.min(this.minAmperage, cable.getAmps());
        if (!cable.insulated()) {
            this.uninsulatedCables.add(pos);
        }
    }

    public static class State {
        long ampsReceived = 0L;
        long ampsSent;
        long euReceived = 0L;
        long euSent;
        public final IGTNode handler;

        public State(IGTNode handler) {
            this.handler = handler;
        }

        public void onTick() {
            this.ampsReceived = 0L;
            this.euReceived = 0L;
            this.ampsSent = 0L;
            this.euSent = 0L;
        }

        public long extract(boolean simulate, long amps) {
            if (this.handler.canOutput()) {
                if (simulate) {
                    return Math.min(amps, this.handler.getOutputAmperage() - this.ampsSent);
                }
                if (this.ampsSent + amps > this.handler.getOutputAmperage()) {
                    return 0L;
                }
                if (!simulate) {
                    this.ampsSent += amps;
                }
                return amps;
            }
            return 0L;
        }

        public long receive(boolean simulate, long amps) {
            if (this.handler.canInput()) {
                if (simulate) {
                    return Math.min(amps, this.handler.getInputAmperage() - this.ampsReceived);
                }
                if (this.ampsReceived + amps > this.handler.getInputAmperage()) {
                    return 0L;
                }
                if (!simulate) {
                    this.ampsReceived += amps;
                }
                return amps;
            }
            return 0L;
        }

        public long getAmpsReceived() {
            return this.ampsReceived;
        }

        public long getAmpsSent() {
            return this.ampsSent;
        }
    }
}

