/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fabric.wrapper;

import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleSidedEnergyContainer;
import tesseract.TesseractConfig;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.IEnergyHandler;

public class EnergyTileWrapper
implements IEnergyHandler {
    private final class_2586 tile;
    private final EnergyStorage storage;
    private final GTConsumer.State state = new GTConsumer.State(this);

    public EnergyTileWrapper(class_2586 tile, EnergyStorage storage) {
        this.tile = tile;
        this.storage = storage;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = (long)((double)this.storage.insert((long)((double)voltage * TesseractConfig.EU_TO_TRE_RATIO.get()), (TransactionContext)transaction) / TesseractConfig.EU_TO_TRE_RATIO.get());
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = (long)((double)this.storage.extract((long)((double)voltage * TesseractConfig.EU_TO_TRE_RATIO.get()), (TransactionContext)transaction) / TesseractConfig.EU_TO_TRE_RATIO.get());
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long getEnergy() {
        return (long)((double)this.storage.getAmount() / TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    @Override
    public long getCapacity() {
        return (long)((double)this.storage.getCapacity() / TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputVoltage() {
        EnergyStorage energyStorage = this.storage;
        if (energyStorage instanceof SimpleSidedEnergyContainer) {
            SimpleSidedEnergyContainer limitingEnergyStorage = (SimpleSidedEnergyContainer)energyStorage;
            return limitingEnergyStorage.getMaxExtract(null);
        }
        return 32L;
    }

    @Override
    public long getInputAmperage() {
        return 16L;
    }

    @Override
    public long getInputVoltage() {
        EnergyStorage energyStorage = this.storage;
        if (energyStorage instanceof SimpleSidedEnergyContainer) {
            SimpleSidedEnergyContainer limitingEnergyStorage = (SimpleSidedEnergyContainer)energyStorage;
            return limitingEnergyStorage.getMaxInsert(null);
        }
        return 8192L;
    }

    @Override
    public long availableAmpsInput(long voltage) {
        long added = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            added = this.storage.insert((long)((double)voltage * TesseractConfig.EU_TO_TRE_RATIO.get()), (TransactionContext)transaction);
        }
        if ((double)added == (double)voltage * TesseractConfig.EU_TO_TRE_RATIO.get()) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean canOutput() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && this.storage.supportsExtraction();
    }

    @Override
    public boolean canInput() {
        return TesseractConfig.ENABLE_TRE_COMPAT.get() && this.storage.supportsInsertion();
    }

    @Override
    public boolean canInput(class_2350 dir) {
        return this.canInput();
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return this.canOutput();
    }

    @Override
    public GTConsumer.State getState() {
        return this.state;
    }

    @Override
    public void tesseractTick() {
        this.getState().onTick();
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        return null;
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }
}

