/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph.traverse;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import net.minecraft.class_2350;
import tesseract.graph.Graph;
import tesseract.graph.INode;
import tesseract.util.Pos;

public class BFSearcher {
    private final INode container;
    private final LongPriorityQueue open = new LongArrayFIFOQueue();
    private final LongOpenHashSet closed = new LongOpenHashSet();

    public BFSearcher(INode container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(long from, LongConsumer reached, Consumer<LongSet> excluder) {
        if (!this.closed.isEmpty() || !this.open.isEmpty()) {
            throw new ConcurrentModificationException("Attempted to run concurrent search operations on the same BFSearcher instance");
        }
        if (excluder != null) {
            excluder.accept((LongSet)this.closed);
        }
        try {
            if (!this.container.contains(from)) {
                return;
            }
            this.open.enqueue(from);
            while (!this.open.isEmpty()) {
                long current = this.open.dequeueLong();
                if (this.closed.contains(current)) continue;
                this.closed.add(current);
                reached.accept(current);
                Pos position = new Pos(current);
                for (class_2350 direction : Graph.DIRECTIONS) {
                    long pos = position.offset(direction).asLong();
                    if (this.closed.contains(pos) || !this.container.linked(current, direction, pos)) continue;
                    this.open.enqueue(pos);
                }
            }
        }
        finally {
            this.open.clear();
            this.closed.clear();
        }
    }
}

