/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import tesseract.api.IConnectable;
import tesseract.graph.Cache;
import tesseract.graph.Connectivity;
import tesseract.graph.Graph;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.Path;
import tesseract.graph.traverse.ASFinder;
import tesseract.graph.traverse.BFDivider;
import tesseract.util.Node;
import tesseract.util.Pos;

public class Grid<C extends IConnectable>
implements INode {
    private final Long2ObjectMap<Cache<C>> connectors = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectMap<NodeCache<?>> nodes = new Long2ObjectLinkedOpenHashMap();
    private final BFDivider divider = new BFDivider(this);
    private final ASFinder finder = new ASFinder(this);

    private Grid() {
    }

    protected static <C extends IConnectable> Grid<C> singleConnector(long pos, Cache<C> connector) {
        Grid<C> grid = new Grid<C>();
        grid.connectors.put(pos, connector);
        return grid;
    }

    @Override
    public boolean contains(long pos) {
        return this.connectors.containsKey(pos) || this.nodes.containsKey(pos);
    }

    @Override
    public boolean linked(long from, class_2350 towards, long to) {
        byte connectivityTo;
        NodeCache cache;
        byte connectivityFrom;
        assert (towards != null);
        Cache cacheFrom = (Cache)this.connectors.get(from);
        Cache cacheTo = (Cache)this.connectors.get(to);
        boolean validLink = false;
        if (cacheFrom != null) {
            validLink = true;
            connectivityFrom = cacheFrom.connectivity();
        } else {
            cache = (NodeCache)this.nodes.get(from);
            byte by = connectivityFrom = cache == null ? (byte)0 : Connectivity.of(cache);
        }
        if (cacheTo != null) {
            validLink = true;
            connectivityTo = cacheTo.connectivity();
        } else {
            cache = (NodeCache)this.nodes.get(to);
            byte by = connectivityTo = cache == null ? (byte)0 : Connectivity.of(cache);
        }
        if (connectivityFrom == 0 && connectivityTo == 0) {
            return false;
        }
        return validLink && Connectivity.has(connectivityFrom, towards.method_10146()) && Connectivity.has(connectivityTo, towards.method_10153().method_10146());
    }

    @Override
    public boolean connects(long pos, class_2350 towards) {
        assert (towards != null);
        Cache cache = (Cache)this.connectors.get(pos);
        if (cache != null) {
            byte connectivity = cache.connectivity();
            return Connectivity.has(connectivity, towards.method_10146());
        }
        NodeCache c = (NodeCache)this.nodes.get(pos);
        return c != null && c.connects(towards);
    }

    public int countConnectors() {
        return this.connectors.size();
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public Long2ObjectMap<Cache<C>> getConnectors() {
        return Long2ObjectMaps.unmodifiable(this.connectors);
    }

    public Long2ObjectMap<NodeCache<?>> getNodes() {
        return Long2ObjectMaps.unmodifiable(this.nodes);
    }

    public List<Path<C>> getPaths(long from) {
        ObjectArrayList data = new ObjectArrayList();
        this.nodes.keySet().forEach(arg_0 -> this.lambda$getPaths$0(from, (List)data, arg_0));
        return data;
    }

    public Deque<Node> getPath(long origin, long target) {
        return this.finder.traverse(origin, target);
    }

    public void mergeWith(Grid<C> other) {
        this.connectors.putAll(other.connectors);
        this.nodes.putAll(other.nodes);
    }

    public long sampleConnector() {
        LongIterator it = this.connectors.keySet().iterator();
        return it.hasNext() ? it.nextLong() : Long.MAX_VALUE;
    }

    public void addConnector(long pos, Cache<C> connector) {
        this.connectors.put(pos, connector);
    }

    public void addNode(long pos, NodeCache<?> cache) {
        this.nodes.put(pos, cache);
    }

    public void removeNode(long pos) {
        this.nodes.remove(pos);
    }

    public void removeAt(long pos, Consumer<Grid<C>> split) {
        if (!this.contains(pos)) {
            throw new IllegalArgumentException("Grid::remove: Tried to call with a position that does not exist within the grid.");
        }
        if (this.isExternal(pos)) {
            this.removeFinal(pos);
            return;
        }
        ObjectArrayList colored = new ObjectArrayList();
        int bestColor = this.divider.divide(removed -> removed.add(pos), roots -> {
            for (class_2350 direction : Graph.DIRECTIONS) {
                long side = Pos.offset(pos, direction);
                if (!this.linked(pos, direction, side)) continue;
                roots.add(side);
            }
        }, ((List)colored)::add);
        LongLinkedOpenHashSet check = new LongLinkedOpenHashSet();
        for (int i = 0; i < colored.size(); ++i) {
            if (i == bestColor) continue;
            Grid<C> newGrid = new Grid<C>();
            LongSet found = (LongSet)colored.get(i);
            LongIterator longIterator = found.iterator();
            while (longIterator.hasNext()) {
                long reached = (Long)longIterator.next();
                if (this.nodes.containsKey(reached)) {
                    check.add(reached);
                    newGrid.nodes.put(reached, (Object)((NodeCache)this.nodes.get(reached)));
                    continue;
                }
                newGrid.connectors.put(reached, (Object)((Cache)this.connectors.remove(reached)));
            }
            split.accept(newGrid);
        }
        this.removeFinal(pos);
        LongIterator longIterator = check.iterator();
        while (longIterator.hasNext()) {
            long reached = (Long)longIterator.next();
            if (!this.isExternal(reached)) continue;
            this.nodes.remove(reached);
        }
    }

    private void removeFinal(long pos) {
        this.connectors.remove(pos);
        for (class_2350 direction : Graph.DIRECTIONS) {
            long side = Pos.offset(pos, direction);
            if (!this.nodes.containsKey(side) || !this.isExternal(side) || !((NodeCache)this.nodes.get(side)).connects(direction.method_10153())) continue;
            this.nodes.remove(side);
        }
    }

    private boolean isExternal(long pos) {
        if (this.countConnectors() <= 1) {
            return true;
        }
        int neighbors = 0;
        for (class_2350 direction : Graph.DIRECTIONS) {
            long side = Pos.offset(pos, direction);
            if (this.nodes.containsKey(side) || !this.linked(pos, direction, side)) continue;
            ++neighbors;
        }
        return neighbors <= 1;
    }

    private /* synthetic */ void lambda$getPaths$0(long from, List data, long to) {
        if (to != from) {
            data.add(new Path<C>(this.connectors, this.finder.traverse(from, to)));
        }
    }
}

