/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.gt;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import tesseract.Tesseract;
import tesseract.api.ConnectionType;
import tesseract.api.Controller;
import tesseract.api.ITickingController;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.GTHolder;
import tesseract.api.gt.GTStatus;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IGTCable;
import tesseract.api.gt.IGTEvent;
import tesseract.api.gt.IGTNode;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.Grid;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.Path;
import tesseract.util.Node;
import tesseract.util.Pos;

public class GTController
extends Controller<GTTransaction, IGTCable, IGTNode>
implements IGTEvent {
    private long totalVoltage;
    private long totalAmperage;
    private long lastVoltage;
    private long lastAmperage;
    private double totalLoss;
    private double lastLoss;
    private Long2LongMap frameHolders = new Long2LongLinkedOpenHashMap();
    private Long2LongMap previousFrameHolder = new Long2LongLinkedOpenHashMap();
    private final Long2ObjectMap<Map<class_2350, List<GTConsumer>>> data = new Long2ObjectLinkedOpenHashMap();
    public final LongSet cableIsActive = new LongOpenHashSet();
    Long2IntMap pipeMap;
    int inserted;

    public GTController(class_1937 dim, Graph.INodeGetter<IGTNode> getter) {
        super(dim, getter);
    }

    @Override
    public void change() {
        if (!this.changeInternal()) {
            Tesseract.LOGGER.warn("Error during GTController::change.");
        }
    }

    private boolean changeInternal() {
        this.data.clear();
        for (Long2ObjectMap.Entry e : this.group.getNodes().long2ObjectEntrySet()) {
            long pos = e.getLongKey();
            for (Map.Entry tup : ((NodeCache)e.getValue()).values()) {
                class_2350 direction;
                IGTNode producer = (IGTNode)tup.getValue();
                if (!producer.canOutput(direction = tup.getKey())) continue;
                long side = Pos.offset(pos, direction);
                ObjectArrayList consumers = new ObjectArrayList();
                Grid grid = this.group.getGridAt(side, direction);
                if (grid != null) {
                    for (Path<IGTCable> path : grid.getPaths(pos)) {
                        if (path.isEmpty()) continue;
                        Node target = path.target();
                        assert (target != null);
                        if (this.onCheck(producer, (List<GTConsumer>)consumers, path, target.asLong(), target.getDirection())) continue;
                        return false;
                    }
                } else if (this.group.getNodes().containsKey(side)) {
                    this.onCheck(producer, (List<GTConsumer>)consumers, null, side, direction.method_10153());
                }
                if (consumers.isEmpty()) continue;
                ((Map)this.data.computeIfAbsent(pos, m -> new EnumMap(class_2350.class))).put(direction.method_10153(), consumers);
            }
        }
        for (Map map : this.data.values()) {
            for (List consumers : map.values()) {
                consumers.sort(GTConsumer.COMPARATOR);
            }
        }
        return true;
    }

    private boolean onCheck(IGTNode producer, List<GTConsumer> consumers, Path<IGTCable> path, long consumerPos, class_2350 dir) {
        NodeCache nodee = (NodeCache)this.group.getNodes().get(consumerPos);
        IGTNode node = (IGTNode)nodee.value(dir);
        if (node != null && node.canInput(dir)) {
            GTConsumer consumer = new GTConsumer(node, producer, path);
            long voltage = producer.getOutputVoltage() - Math.round(consumer.getLoss());
            if (voltage <= 0L) {
                return true;
            }
            consumers.add(consumer);
            return true;
        }
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        for (Cache connector : this.group.connectors()) {
            ((IGTCable)connector.value()).setHolder(GTHolder.create((IGTCable)connector.value(), 0L));
        }
        for (NodeCache node : this.group.getNodes().values()) {
            Iterator iterator = node.values().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry n = iterator.next();
            ((IGTNode)n.getValue()).tesseractTick();
        }
        this.pipeMap = new Long2IntOpenHashMap();
        this.inserted = 0;
    }

    @Override
    public void insert(long pipePos, class_2350 side, GTTransaction stack, ITransactionModifier modifier) {
        Map map = (Map)this.data.get(Pos.offset(pipePos, side));
        if (map == null) {
            return;
        }
        List list = (List)map.get(side);
        if (list == null) {
            return;
        }
        NodeCache node = (NodeCache)this.group.getNodes().get(Pos.offset(pipePos, side));
        if (node == null) {
            return;
        }
        IGTNode producer = (IGTNode)node.value(side.method_10153());
        long voltage_out = producer.getOutputVoltage();
        if (stack.voltage > voltage_out) {
            return;
        }
        ++this.inserted;
        ArrayList<Consumer<Long2ObjectMap>> transferList = new ArrayList<Consumer<Long2ObjectMap>>();
        double previousLoss = 0.0;
        for (GTConsumer consumer : list) {
            long remainingEu = stack.eu;
            if (remainingEu <= 0L) break;
            double loss = consumer.getLoss();
            double appliedLoss = loss == 0.0 ? 0.0 : (loss > previousLoss ? loss - previousLoss : previousLoss - loss);
            previousLoss = loss;
            long roundedAppliedLoss = Math.round(appliedLoss);
            if (roundedAppliedLoss < 0L || roundedAppliedLoss > remainingEu) continue;
            long lossyEu = remainingEu - roundedAppliedLoss;
            long euInserted = ((IGTNode)consumer.getNode()).insertEu(lossyEu, true);
            if (euInserted <= 0L) continue;
            GTTransaction.TransferData data1 = stack.addData(euInserted, euInserted + roundedAppliedLoss, appliedLoss, a -> {});
            transferList.add(l -> this.dataCommit((Long2ObjectMap<IGTCable>)l, consumer, data1));
        }
        if (!transferList.isEmpty()) {
            stack.addData(0L, 0L, 0.0, d -> this.dataCommit(transferList));
        }
    }

    public void dataCommit(Long2ObjectMap<IGTCable> cableList, GTConsumer consumer, GTTransaction.TransferData data) {
        if (!consumer.canHandle(data.getVoltage())) {
            for (Long2ObjectMap.Entry c : consumer.getFull().long2ObjectEntrySet()) {
                long pos = c.getLongKey();
                IGTCable cable = (IGTCable)c.getValue();
                if (Objects.requireNonNull(cable.getHandler(data.getVoltage(), 0L)) != GTStatus.FAIL_VOLTAGE) continue;
                this.onCableOverVoltage(this.getWorld(), pos, data.getVoltage());
                return;
            }
        } else {
            for (Long2ObjectMap.Entry c : consumer.getFull().long2ObjectEntrySet()) {
                IGTCable cable = (IGTCable)c.getValue();
                if (cableList.containsKey(c.getLongKey())) continue;
                cableList.put(c.getLongKey(), (Object)cable);
            }
        }
        this.cableIsActive.addAll((LongCollection)consumer.uninsulatedCables);
        this.totalLoss += data.getLoss();
        this.totalVoltage += data.getEu();
        ((IGTNode)consumer.getNode()).insertEu(data.getEu(), false);
    }

    public void dataCommit(List<Consumer<Long2ObjectMap<IGTCable>>> list) {
        Long2ObjectOpenHashMap cableList = new Long2ObjectOpenHashMap();
        for (Consumer<Long2ObjectMap<IGTCable>> pair : list) {
            pair.accept((Long2ObjectMap<IGTCable>)cableList);
        }
        for (Long2ObjectMap.Entry c : cableList.long2ObjectEntrySet()) {
            long pos = c.getLongKey();
            IGTCable cable = (IGTCable)c.getValue();
            cable.setHolder(GTHolder.add(cable.getHolder(), 1L));
            if (!GTHolder.isOverAmperage(cable.getHolder())) continue;
            this.onCableOverAmperage(this.getWorld(), pos, GTHolder.getAmperage(cable.getHolder()));
            return;
        }
        ++this.totalAmperage;
    }

    public void dataCommit(GTConsumer consumer, GTTransaction.TransferData data) {
        IGTCable cable;
        long pos;
        if (!consumer.canHandle(data.getVoltage()) || !consumer.canHandleAmp(1L) || consumer.getConnection() == ConnectionType.SINGLE && !consumer.canHandleAmp(1L)) {
            for (Long2ObjectMap.Entry c : consumer.getFull().long2ObjectEntrySet()) {
                pos = c.getLongKey();
                cable = (IGTCable)c.getValue();
                switch (cable.getHandler(data.getVoltage(), 1L)) {
                    case FAIL_VOLTAGE: {
                        this.onCableOverVoltage(this.getWorld(), pos, data.getVoltage());
                        return;
                    }
                    case FAIL_AMPERAGE: {
                        this.onCableOverAmperage(this.getWorld(), pos, 1L);
                        return;
                    }
                }
            }
        }
        if (consumer.getConnection() == ConnectionType.VARIATE) {
            for (Long2ObjectMap.Entry c : consumer.getCross().long2ObjectEntrySet()) {
                pos = c.getLongKey();
                cable = (IGTCable)c.getValue();
                cable.setHolder(GTHolder.add(cable.getHolder(), 1L));
                if (!GTHolder.isOverAmperage(cable.getHolder())) continue;
                this.onCableOverAmperage(this.getWorld(), pos, GTHolder.getAmperage(cable.getHolder()));
                return;
            }
        }
        this.cableIsActive.addAll((LongCollection)consumer.uninsulatedCables);
        this.totalLoss += data.getLoss();
        ++this.totalAmperage;
        this.totalVoltage += data.getEu();
        ((IGTNode)consumer.getNode()).insertEu(data.getEu(), false);
    }

    @Override
    protected void onFrame() {
        this.lastVoltage = this.totalVoltage;
        this.lastAmperage = this.totalAmperage;
        this.lastLoss = this.totalLoss;
        this.totalVoltage = 0L;
        this.totalAmperage = 0L;
        this.totalLoss = 0.0;
        this.previousFrameHolder = this.frameHolders;
        this.frameHolders = new Long2LongOpenHashMap();
        this.cableIsActive.clear();
    }

    @Override
    public void getInfo(long pos, @NotNull List<String> list) {
        if (this.group != null) {
            this.group.getGroupInfo(pos, list);
            list.add(String.format("GT Data size: %d", this.data.size()));
        }
    }

    public long getTotalVoltage() {
        return this.lastVoltage;
    }

    public long totalAmps() {
        return this.lastAmperage;
    }

    public int cableFrameAverage(long pos) {
        return GTHolder.getAmperage(this.previousFrameHolder.get(pos));
    }

    public double totalLoss() {
        return this.lastLoss;
    }

    @Override
    public ITickingController clone(INode group) {
        return new GTController(this.dim, this.getter).set(group);
    }
}

