/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fabric.wrapper;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.util.Simulation;
import tesseract.TesseractConfig;
import tesseract.api.gt.IEnergyHandler;

public interface IEnergyHandlerMoveable
extends EnergyExtractable,
EnergyInsertable {
    default public long extractEnergy(long maxExtract, Simulation simulation) {
        long euToInsert = (long)((double)maxExtract / TesseractConfig.EU_TO_TRE_RATIO.get());
        return this.getEnergyHandler().extractEu(euToInsert, simulation.isSimulating());
    }

    default public long insertEnergy(long maxInsert, Simulation simulation) {
        long euToInsert = (long)((double)maxInsert / TesseractConfig.EU_TO_TRE_RATIO.get());
        long inserted = this.getEnergyHandler().insertEu(euToInsert, simulation.isSimulating());
        return (long)((double)inserted * TesseractConfig.EU_TO_TRE_RATIO.get());
    }

    default public boolean canExtract(CableTier cableTier) {
        return this.getEnergyHandler().canOutput();
    }

    default public boolean canInsert(CableTier cableTier) {
        return this.getEnergyHandler().canInput();
    }

    public IEnergyHandler getEnergyHandler();
}

