/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fabric.wrapper;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.api.energy.EnergyMoveable;
import aztech.modern_industrialization.compat.megane.holder.EnergyComponentHolder;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import tesseract.api.fabric.wrapper.IEnergyMoveableTiers;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.IEnergyHandler;

public class EnergyMoveableWrapper
implements IEnergyHandler {
    private final class_2586 blockEntity;
    private final EnergyMoveable storage;
    private final GTConsumer.State state = new GTConsumer.State(this);

    public EnergyMoveableWrapper(class_2586 blockEntity, EnergyMoveable storage) {
        this.storage = storage;
        this.blockEntity = blockEntity;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        EnergyExtractable extractable;
        EnergyMoveable energyMoveable = this.storage;
        if (energyMoveable instanceof EnergyExtractable && (extractable = (EnergyExtractable)energyMoveable).canExtract(this.getTier(voltage))) {
            return extractable.extractEnergy(voltage, simulate ? Simulation.SIMULATE : Simulation.ACT);
        }
        return 0L;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        EnergyInsertable insertable;
        EnergyMoveable energyMoveable = this.storage;
        if (energyMoveable instanceof EnergyInsertable && (insertable = (EnergyInsertable)energyMoveable).canInsert(this.getTier(voltage))) {
            return insertable.insertEnergy(voltage, simulate ? Simulation.SIMULATE : Simulation.ACT);
        }
        return 0L;
    }

    public CableTier getTier(long tier) {
        if (tier <= 32L) {
            return CableTier.LV;
        }
        if (tier <= 128L) {
            return CableTier.MV;
        }
        if (tier <= 1024L) {
            return CableTier.HV;
        }
        if (tier < 8192L) {
            return CableTier.EV;
        }
        return CableTier.SUPERCONDUCTOR;
    }

    @Override
    public long getEnergy() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof EnergyComponentHolder) {
            EnergyComponentHolder holder = (EnergyComponentHolder)class_25862;
            return holder.getEnergyComponent().getEu();
        }
        return 0L;
    }

    @Override
    public long getCapacity() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof EnergyComponentHolder) {
            EnergyComponentHolder holder = (EnergyComponentHolder)class_25862;
            return holder.getEnergyComponent().getCapacity();
        }
        return 0L;
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputVoltage() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof IEnergyMoveableTiers) {
            IEnergyMoveableTiers tiers = (IEnergyMoveableTiers)class_25862;
            return tiers.getOutputVoltage();
        }
        return 32L;
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        class_2586 class_25862 = this.blockEntity;
        if (class_25862 instanceof IEnergyMoveableTiers) {
            IEnergyMoveableTiers tiers = (IEnergyMoveableTiers)class_25862;
            return tiers.getInputVoltage();
        }
        return 32L;
    }

    @Override
    public boolean canOutput() {
        return this.storage instanceof EnergyExtractable;
    }

    @Override
    public boolean canInput() {
        return this.storage instanceof EnergyInsertable;
    }

    @Override
    public boolean canInput(class_2350 dir) {
        return this.canInput();
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return this.canOutput();
    }

    @Override
    public GTConsumer.State getState() {
        return this.state;
    }

    @Override
    public void tesseractTick() {
        this.getState().onTick();
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        return null;
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }
}

