/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import tesseract.Tesseract;
import tesseract.api.Controller;
import tesseract.api.IConnectable;
import tesseract.api.ITickingController;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.Group;
import tesseract.graph.NodeCache;
import tesseract.util.Pos;

public class GraphWrapper<T, C extends IConnectable, N> {
    private static final ObjectSet<GraphWrapper<?, ?, ?>> ALL_WRAPPERS = new ObjectOpenHashSet();
    protected final Object2ObjectMap<class_1936, Graph<T, C, N>> graph = new Object2ObjectOpenHashMap();
    protected final BiFunction<class_1937, Graph.INodeGetter<N>, Controller<T, C, N>> supplier;
    protected final ICapabilityGetter<N> getter;
    private final Map<class_1937, LongSet> pendingConnectors = new Object2ObjectOpenHashMap();

    public GraphWrapper(BiFunction<class_1937, Graph.INodeGetter<N>, Controller<T, C, N>> supplier, ICapabilityGetter<N> getter) {
        this.supplier = supplier;
        this.getter = getter;
        ALL_WRAPPERS.add((Object)this);
    }

    public void registerConnector(class_1937 dim, long pos, C connector, boolean regular) {
        if (!Tesseract.TEST && dim.method_8608()) {
            return;
        }
        if (regular) {
            this.getGraph((class_1936)dim).addConnector(pos, Cache.of(connector));
            if (!Tesseract.hadFirstTick((class_1936)dim)) {
                this.pendingConnectors.computeIfAbsent(dim, d -> new LongOpenHashSet()).add(pos);
            } else {
                this.addAdjacentNodes(dim, pos);
            }
        }
    }

    public void blockUpdate(class_1937 dim, long connector, long node) {
        this.update(dim, node, Pos.subToDir(connector, node), false);
    }

    public Graph<T, C, N> getGraph(class_1936 dim) {
        assert (Tesseract.TEST || !dim.method_8608());
        Graph.INodeGetter<Object> get = (a, b, c) -> this.getter.get((class_1937)dim, a, b, c);
        return (Graph)this.graph.computeIfAbsent((Object)dim, k -> new Graph(() -> this.supplier.apply((class_1937)dim, get)));
    }

    @NotNull
    public ITickingController<T, C, N> getController(class_1937 dim, long pos) {
        if (!Tesseract.TEST && dim.method_8608()) {
            throw new IllegalStateException("Call to GraphWrapper::getController on client side!");
        }
        Group<T, C, N> group = this.getGraph((class_1936)dim).getGroupAt(pos);
        Graph.INodeGetter<Object> get = (a, b, c) -> this.getter.get(dim, a, b, c);
        return group != null ? group.getController() : (ITickingController)this.supplier.apply(dim, get);
    }

    private void update(class_1937 dim, long pos, @NotNull class_2350 side, boolean isInvalidate) {
        NodeCache nodeCache;
        long cPos = Pos.offset(pos, side);
        Graph<T, C, Object> graph = this.getGraph((class_1936)dim);
        Group<T, C, N> group = graph.getGroupAt(cPos);
        if (group == null) {
            return;
        }
        Cache<C> cCache = group.getConnector(cPos);
        if (cCache == null && (nodeCache = (NodeCache)group.getNodes().get(cPos)) == null) {
            return;
        }
        NodeCache<Object> cache = (NodeCache<Object>)group.getNodes().get(pos);
        Graph.INodeGetter<Object> get = (a, b, c) -> this.getter.get(dim, a, b, c);
        if (cache == null) {
            cache = new NodeCache<Object>(pos, get, a -> this.validate(graph, a.direction(), a.position()), a -> this.update(dim, a.position(), a.direction(), true));
            graph.addNode(cache);
        } else {
            if (isInvalidate && cache.updateSide(side)) {
                group.getController().change();
                return;
            }
            this.updateNode(graph, pos);
        }
    }

    public void addAdjacentNodes(class_1937 dim, long pos) {
        Graph<T, C, Object> graph = this.getGraph((class_1936)dim);
        Graph.INodeGetter<Object> get = (a, b, c) -> this.getter.get(dim, a, b, c);
        for (class_2350 dir : Graph.DIRECTIONS) {
            long nodePos = Pos.offset(pos, dir);
            NodeCache<Object> cache = new NodeCache<Object>(nodePos, get, a -> this.validate(graph, a.direction(), a.position()), a -> this.update(dim, a.position(), a.direction(), true));
            graph.addNode(cache);
        }
    }

    public void onFirstTick(class_1937 dim) {
        LongSet set = this.pendingConnectors.remove(dim);
        if (set != null) {
            set.forEach(l -> this.addAdjacentNodes(dim, l));
        }
    }

    private void updateNode(Graph<T, C, N> graph, long nodePos) {
        Group<T, C, N> group = graph.getGroupAt(nodePos);
        if (group == null) {
            return;
        }
        NodeCache cache = (NodeCache)group.getNodes().get(nodePos);
        if (cache == null) {
            return;
        }
        int count = cache.capCount();
        boolean ok = this.updateNodeSides(cache);
        if (cache.capCount() != count || cache.capCount() == 0) {
            graph.removeAt(nodePos);
            if (ok) {
                graph.addNode(cache);
            }
        } else {
            group.getController().change();
        }
    }

    private boolean removeAt(Graph<T, C, N> graph, long pos) {
        Group<T, C, N> gr = graph.getGroupAt(pos);
        if (gr == null) {
            return false;
        }
        boolean ok = graph.removeAt(pos);
        if (ok) {
            for (class_2350 dir : Graph.DIRECTIONS) {
                this.updateNode(graph, Pos.offset(pos, dir));
            }
        }
        return ok;
    }

    private boolean updateNodeSides(NodeCache<N> node) {
        for (int i = 0; i < Graph.DIRECTIONS.length; ++i) {
            node.updateSide(Graph.DIRECTIONS[i]);
        }
        return node.capCount() > 0;
    }

    boolean validate(Graph<T, C, N> graph, class_2350 side, long pos) {
        Group<T, C, N> group = graph.getGroupAt(Pos.offset(pos, side));
        if (group == null) {
            return false;
        }
        Cache<C> conn = group.getConnector(Pos.offset(pos, side));
        if (conn != null) {
            return conn.value().validate(side.method_10153());
        }
        return false;
    }

    public boolean remove(class_1937 dim, long pos) {
        if (!Tesseract.TEST && dim.method_8608()) {
            return false;
        }
        return this.removeAt(this.getGraph((class_1936)dim), pos);
    }

    public void tick(class_1937 dim) {
        Graph g = (Graph)this.graph.get((Object)dim);
        if (g != null) {
            g.getGroups().forEach((pos, gr) -> gr.getController().tick());
        }
    }

    public static Set<GraphWrapper<?, ?, ?>> getWrappers() {
        return ObjectSets.unmodifiable(ALL_WRAPPERS);
    }

    public void removeWorld(class_1937 world) {
        this.graph.remove((Object)world);
    }

    public void clear() {
        this.graph.clear();
    }

    public void healthCheck() {
        this.graph.values().forEach(v -> v.getGroups().values().forEach(Group::healthCheck));
    }

    public static interface ICapabilityGetter<T> {
        public T get(class_1937 var1, long var2, class_2350 var4, Runnable var5);
    }
}

