/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import com.gtnewhorizon.structurelib.util.MiscUtils;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public final class ItemStackPredicate
implements Predicate<ItemStack> {
    private final Item item;
    private CompoundTag tag;
    private NBTMode mode = NBTMode.IGNORE;

    public static ItemStackPredicate from(Item item) {
        return new ItemStackPredicate(item);
    }

    public static ItemStackPredicate from(ItemStack itemStack) {
        return new ItemStackPredicate(itemStack.m_41720_());
    }

    public static ItemStackPredicate from(ItemStack itemStack, NBTMode mode) {
        return new ItemStackPredicate(itemStack.m_41720_()).setTag(mode, itemStack.m_41783_());
    }

    public static ItemStackPredicate from(Block block) {
        return new ItemStackPredicate(block.m_5456_());
    }

    private ItemStackPredicate(Item item) {
        this.item = item;
    }

    public ItemStackPredicate setTag(NBTMode mode, CompoundTag tag) {
        this.mode = mode;
        this.tag = tag;
        return this;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        if (this.item != null && itemStack.m_41720_() != this.item) {
            return false;
        }
        return this.mode.test(this.tag, itemStack.m_41783_());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NBTMode implements BiPredicate<CompoundTag, CompoundTag>
    {
        IGNORE{

            @Override
            public boolean test(CompoundTag lhs, CompoundTag rhs) {
                return true;
            }
        }
        ,
        IN{

            @Override
            public boolean test(CompoundTag lhs, CompoundTag rhs) {
                if (lhs == null || lhs.m_128456_()) {
                    return true;
                }
                if (rhs == null || rhs.m_128456_()) {
                    return false;
                }
                for (String key : MiscUtils.getTagKeys(lhs)) {
                    CompoundTag compoundTag;
                    if (!rhs.m_128425_(key, (int)lhs.m_128435_(key))) {
                        return false;
                    }
                    Tag tag = lhs.m_128423_(key);
                    if (!(tag instanceof CompoundTag ? !this.test(compoundTag = (CompoundTag)tag, rhs.m_128469_(key)) : !tag.equals(rhs.m_128423_(key)))) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        EXACT{

            @Override
            public boolean test(CompoundTag lhs, CompoundTag rhs) {
                if (lhs != null && lhs.m_128456_()) {
                    lhs = null;
                }
                if (rhs != null && rhs.m_128456_()) {
                    rhs = null;
                }
                return Objects.equals(lhs, rhs);
            }
        }
        ,
        IGNORE_KNOWN_INSIGNIFICANT_TAGS{

            @Override
            public boolean test(CompoundTag lhs, CompoundTag rhs) {
                if (rhs == null || rhs.m_128456_()) {
                    return lhs == null || lhs.m_128456_();
                }
                rhs = rhs.m_6426_();
                for (String s : KNOWN_INSIGNIFICANT_TAGS) {
                    rhs.m_128473_(s);
                }
                return EXACT.test(lhs, rhs);
            }
        };

        private static final String[] KNOWN_INSIGNIFICANT_TAGS;

        static {
            KNOWN_INSIGNIFICANT_TAGS = new String[]{"display"};
        }
    }
}

