/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackMap<T>
extends AbstractMap<ItemStack, T> {
    public static final CompoundTag WILDCARD_TAG = new CompoundTag();
    private final HashMap<Item, DetailMap> itemMap = new HashMap();
    private int size;
    private final boolean NBTSensitive;

    static ItemStack newItemStack(Item item, int size, CompoundTag tag) {
        ItemStack stack = new ItemStack((ItemLike)item, size);
        stack.m_41751_(tag);
        return stack;
    }

    static ItemStack wildcard(Item item, boolean nbtsensitive) {
        return ItemStackMap.newItemStack(item, 1, (CompoundTag)(nbtsensitive ? WILDCARD_TAG : null));
    }

    static boolean isWildcard(CompoundTag tag) {
        return tag != null && tag.m_128471_("*");
    }

    public ItemStackMap() {
        this.NBTSensitive = false;
    }

    public ItemStackMap(boolean NBTSensitive) {
        this.NBTSensitive = NBTSensitive;
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.m_41720_() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.m_41720_());
        return map == null ? null : (T)map.get(stack);
    }

    @Override
    public T put(ItemStack key, T value) {
        if (key == null || key.m_41720_() == null || value == null) {
            return null;
        }
        return this.itemMap.computeIfAbsent(key.m_41720_(), (? super K k) -> new DetailMap(this.NBTSensitive)).put(key, value);
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.m_41720_() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.m_41720_());
        return map == null ? null : (T)map.remove(stack);
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof ItemStack)) {
            return false;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.m_41720_() == null) {
            return false;
        }
        DetailMap map = this.itemMap.get(stack.m_41720_());
        return map != null && map.get(stack) != null;
    }

    @Override
    public T merge(ItemStack key, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
        if (key == null || key.m_41720_() == null || value == null || remappingFunction == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(key.m_41720_());
        return this.itemMap.computeIfAbsent(key.m_41720_(), (? super K k) -> new DetailMap(this.NBTSensitive)).merge(key, value, remappingFunction);
    }

    @Override
    public T computeIfAbsent(ItemStack key, Function<? super ItemStack, ? extends T> mappingFunction) {
        if (key == null || key.m_41720_() == null || mappingFunction == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(key.m_41720_());
        return this.itemMap.computeIfAbsent(key.m_41720_(), (? super K k) -> new DetailMap(this.NBTSensitive)).computeIfAbsent(key, mappingFunction);
    }

    @Override
    public void clear() {
        this.itemMap.clear();
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<ItemStack, T>> entrySet() {
        return new SetView();
    }

    static {
        WILDCARD_TAG.m_128379_("*", true);
    }

    private class DetailMap {
        private boolean hasWildcard;
        private T wildcard;
        private HashMap<CompoundTag, T> tagMap;
        private int size;
        private final boolean NBTSensitive;

        public DetailMap(boolean NBTSensitive) {
            this.NBTSensitive = NBTSensitive;
        }

        private KeyType getKeyType(CompoundTag tag) {
            return !this.NBTSensitive || ItemStackMap.isWildcard(tag) ? KeyType.WildcardTag : KeyType.NotWildcard;
        }

        public T get(ItemStack key) {
            Object ret;
            if (this.wildcard != null) {
                return this.wildcard;
            }
            if (this.tagMap != null && (ret = this.tagMap.get(key.m_41783_())) != null) {
                return ret;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T put(ItemStack key, T value) {
            try {
                switch (this.getKeyType(key.m_41783_())) {
                    case NotWildcard: {
                        if (this.tagMap == null) {
                            this.tagMap = new HashMap();
                        }
                        Object t = this.tagMap.put(key.m_41783_(), value);
                        return t;
                    }
                    case WildcardTag: {
                        Object ret = this.wildcard;
                        this.wildcard = value;
                        this.hasWildcard = true;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T remove(ItemStack key) {
            try {
                switch (this.getKeyType(key.m_41783_())) {
                    case NotWildcard: {
                        Object t = this.tagMap != null ? (Object)this.tagMap.remove(key.m_41783_()) : null;
                        return t;
                    }
                    case WildcardTag: {
                        Object ret = this.wildcard;
                        this.wildcard = null;
                        this.hasWildcard = false;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        private void updateSize() {
            int newSize = (this.hasWildcard ? 1 : 0) + (this.tagMap != null ? this.tagMap.size() : 0);
            if (newSize != this.size) {
                ItemStackMap.this.size += newSize - this.size;
                this.size = newSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T merge(ItemStack key, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
            try {
                switch (this.getKeyType(key.m_41783_())) {
                    case NotWildcard: {
                        if (this.tagMap == null) {
                            this.tagMap = new HashMap();
                        }
                        Object t = this.tagMap.merge(key.m_41783_(), value, remappingFunction);
                        return t;
                    }
                    case WildcardTag: {
                        Object newValue = this.wildcard == null ? value : remappingFunction.apply(this.wildcard, value);
                        this.wildcard = newValue;
                        this.hasWildcard = newValue != null;
                        Object t = newValue;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T computeIfAbsent(ItemStack key, Function<? super ItemStack, ? extends T> mappingFunction) {
            try {
                switch (this.getKeyType(key.m_41783_())) {
                    case NotWildcard: {
                        if (this.tagMap == null) {
                            this.tagMap = new HashMap();
                        }
                        Object object = this.tagMap.computeIfAbsent(key.m_41783_(), (? super K x) -> mappingFunction.apply(key));
                        return object;
                    }
                    case WildcardTag: {
                        Object newValue;
                        this.wildcard = newValue = this.wildcard == null ? mappingFunction.apply(key) : this.wildcard;
                        this.hasWildcard = newValue != null;
                        Object object = newValue;
                        return object;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }
    }

    private class SetView
    extends AbstractSet<Map.Entry<ItemStack, T>> {
        private SetView() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return Objects.equals(ItemStackMap.this.get(entry.getKey()), entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<ItemStack, T> itemStackTEntry) {
            return itemStackTEntry.getKey() != null && itemStackTEntry.getValue() != null && ItemStackMap.this.put(itemStackTEntry.getKey(), itemStackTEntry.getValue()) == null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ItemStackMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<ItemStack, T>> iterator() {
            return Iterators.concat((Iterator)Iterators.transform(ItemStackMap.this.itemMap.entrySet().iterator(), DetailIter::new));
        }

        @Override
        public int size() {
            return ItemStackMap.this.size;
        }
    }

    private static enum KeyType {
        NotWildcard,
        WildcardTag;

        private static final KeyType[] VALUES;

        static {
            VALUES = KeyType.values();
        }
    }

    private static class DetailIter<T>
    implements Iterator<Map.Entry<ItemStack, T>> {
        private final Item owner;
        private final DetailMap backing;
        @Nullable
        private final Iterator<Map.Entry<CompoundTag, T>> tagIter;
        private DetailIterState state = DetailIterState.NOT_STARTED;
        private boolean removed = false;

        private DetailIter(Map.Entry<Item, DetailMap> input) {
            this.owner = input.getKey();
            this.backing = input.getValue();
            this.tagIter = this.backing.tagMap != null ? this.backing.tagMap.entrySet().iterator() : null;
        }

        private DetailIterState nextState() {
            switch (this.state) {
                case NOT_STARTED: {
                    if (this.backing.hasWildcard) {
                        return DetailIterState.WILDCARD;
                    }
                }
                case WILDCARD: 
                case TAG: {
                    if (this.tagIter != null && this.tagIter.hasNext()) {
                        return DetailIterState.TAG;
                    }
                }
                case DONE: {
                    return DetailIterState.DONE;
                }
            }
            throw new IllegalStateException("Unexpected value: " + this.state);
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException("remove() called twice");
            }
            this.state.remove(this);
            this.removed = true;
        }

        @Override
        public boolean hasNext() {
            return this.nextState() != DetailIterState.DONE;
        }

        @Override
        public Map.Entry<ItemStack, T> next() {
            DetailIterState nextState = this.nextState();
            if (nextState == DetailIterState.DONE) {
                throw new NoSuchElementException();
            }
            this.state = nextState;
            this.removed = false;
            return nextState.get(this);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum DetailIterState {
            NOT_STARTED{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on NOT_STARTED");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new IllegalStateException("next() never called");
                }
            }
            ,
            WILDCARD{

                @Override
                <T> Map.Entry<ItemStack, T> get(final DetailIter<T> iter) {
                    return new Map.Entry<ItemStack, T>(){
                        private final ItemStack key;
                        {
                            this.key = ItemStackMap.wildcard(iter.owner, iter.backing.NBTSensitive);
                        }

                        @Override
                        public ItemStack getKey() {
                            return this.key;
                        }

                        @Override
                        public T getValue() {
                            return iter.backing.wildcard;
                        }

                        @Override
                        public T setValue(T value) {
                            iter.backing.wildcard = value;
                            return iter.backing.wildcard;
                        }
                    };
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (iter.backing.hasWildcard);
                    iter.backing.wildcard = null;
                    iter.backing.hasWildcard = false;
                }
            }
            ,
            TAG{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    assert (iter.tagIter != null);
                    Map.Entry entry = iter.tagIter.next();
                    return new ItemStackEntry(ItemStackMap.newItemStack(iter.owner, 1, entry.getKey()), entry);
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (iter.tagIter != null);
                    iter.tagIter.remove();
                }
            }
            ,
            DONE{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on DONE");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call remove on DONE");
                }
            };


            abstract <T> Map.Entry<ItemStack, T> get(DetailIter<T> var1);

            abstract <T> void remove(DetailIter<T> var1);

            private static class ItemStackEntry<T>
            implements Map.Entry<ItemStack, T> {
                private final ItemStack key;
                private final Map.Entry<?, T> entry;

                public ItemStackEntry(ItemStack key, Map.Entry<?, T> entry) {
                    this.key = key;
                    this.entry = entry;
                }

                @Override
                public ItemStack getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.entry.getValue();
                }

                @Override
                public T setValue(T value) {
                    return this.entry.setValue(value);
                }
            }
        }
    }
}

