/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.util.InventoryIterable;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IItemSource {
    @NotNull
    public Map<ItemStack, Integer> take(Predicate<ItemStack> var1, boolean var2, int var3);

    default public ItemStack takeOne(Predicate<ItemStack> predicate, boolean simulate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        Map<ItemStack, Integer> take = this.take(predicate, simulate, 1);
        return take.isEmpty() ? null : take.keySet().iterator().next();
    }

    default public boolean takeAll(Predicate<ItemStack> predicate, boolean simulate, int count) {
        if (count == 1) {
            return this.takeOne(predicate, simulate) != null;
        }
        Map<ItemStack, Integer> have = this.take(predicate, true, count);
        if (have.values().stream().mapToInt(Integer::intValue).sum() < count) {
            return false;
        }
        this.take(predicate, simulate, count);
        return true;
    }

    default public boolean takeOne(ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || stack.m_41613_() != 1) {
            throw new IllegalArgumentException();
        }
        ItemStack took = this.takeOne(ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT), simulate);
        return took != null && took.m_41613_() > 0;
    }

    default public boolean takeAll(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        if (stack.m_41613_() == 1) {
            return this.takeOne(stack, simulate);
        }
        ItemStackPredicate predicate = ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT);
        Map<ItemStack, Integer> have = this.take(predicate, true, stack.m_41613_());
        if (have.values().stream().mapToInt(Integer::intValue).sum() < stack.m_41613_()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.take(predicate, false, stack.m_41613_());
        return true;
    }

    public static IItemSource fromPlayer(final ServerPlayer player) {
        return new IItemSource(){

            @Override
            @NotNull
            public Map<ItemStack, Integer> take(Predicate<ItemStack> p, boolean s, int c) {
                return InventoryUtility.takeFromInventory(player, p, s, c);
            }

            @Override
            public boolean takeOne(ItemStack stack, boolean simulate) {
                if (stack.m_41619_() || stack.m_41613_() != 1) {
                    throw new IllegalArgumentException();
                }
                return InventoryUtility.takeFromInventory(player, stack, simulate) == 1;
            }

            @Override
            public boolean takeAll(ItemStack stack, boolean simulate) {
                return InventoryUtility.takeFromInventory(player, stack, simulate) == stack.m_41613_();
            }
        };
    }

    public static IItemSource fromInventory(Container inv) {
        return (p, s, c) -> InventoryUtility.takeFromInventory(new InventoryIterable<Container>(inv), p, s, c, true);
    }
}

