/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.command;

import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CommandConfigureChannels {
    private static DynamicCommandExceptionType INVALID_ITEM = new DynamicCommandExceptionType(s -> Component.m_237113_((String)"must hold a hologram"));

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sl_channel").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then((ArgumentBuilder)Commands.m_82129_((String)"channel_name", (ArgumentType)StringArgumentType.word()))).executes(context -> CommandConfigureChannels.processCommand((CommandContext<CommandSourceStack>)context, SubCommand.GET)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"channel_name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CommandConfigureChannels.processCommand((CommandContext<CommandSourceStack>)context, SubCommand.SET)))))).then(Commands.m_82127_((String)"unset").then(Commands.m_82129_((String)"channel_name", (ArgumentType)StringArgumentType.word()).executes(context -> CommandConfigureChannels.processCommand((CommandContext<CommandSourceStack>)context, SubCommand.UNSET))))).then(Commands.m_82127_((String)"wipe").executes(context -> CommandConfigureChannels.processCommand((CommandContext<CommandSourceStack>)context, SubCommand.WIPE)))).then(Commands.m_82127_((String)"getall").executes(context -> CommandConfigureChannels.processCommand((CommandContext<CommandSourceStack>)context, SubCommand.GETALL))));
    }

    private static int processCommand(CommandContext<CommandSourceStack> context, SubCommand command) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldStack = player.m_21205_();
        if (heldStack.m_41619_() || !(heldStack.m_41720_() instanceof ItemConstructableTrigger)) {
            throw INVALID_ITEM.create(null);
        }
        return switch (command) {
            default -> throw new IncompatibleClassChangeError();
            case SubCommand.GET -> {
                String channel = (String)context.getArgument("channel_name", String.class);
                if (ChannelDataAccessor.hasSubChannel(heldStack, channel)) {
                    player.m_5661_((Component)Component.m_237113_((String)(channel + " value: " + ChannelDataAccessor.getChannelData(heldStack, channel))), false);
                    yield 1;
                }
                player.m_5661_((Component)Component.m_237113_((String)(channel + " value: N/A")), false);
                yield 0;
            }
            case SubCommand.SET -> {
                String channel = (String)context.getArgument("channel_name", String.class);
                int value = (Integer)context.getArgument("value", Integer.class);
                ChannelDataAccessor.setChannelData(heldStack, channel, value);
                player.f_36096_.m_38946_();
                player.m_5661_((Component)Component.m_237113_((String)(channel + " value: " + value)), false);
                yield 1;
            }
            case SubCommand.UNSET -> {
                String channel = (String)context.getArgument("channel_name", String.class);
                if (ChannelDataAccessor.hasSubChannel(heldStack, channel)) {
                    ChannelDataAccessor.unsetChannelData(heldStack, channel);
                    player.m_5661_((Component)Component.m_237113_((String)(channel + " cleared")), false);
                    yield 1;
                }
                player.m_5661_((Component)Component.m_237113_((String)(channel + " no value")), false);
                yield 0;
            }
            case SubCommand.WIPE -> {
                ChannelDataAccessor.wipeChannelData(heldStack);
                yield 1;
            }
            case SubCommand.GETALL -> {
                if (!ChannelDataAccessor.hasSubChannel(heldStack)) {
                    player.m_5661_((Component)Component.m_237113_((String)"No subchannel"), false);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"item.structurelib.constructableTrigger.desc.lshift.0", (Object[])new Object[]{ChannelDataAccessor.countChannelData(heldStack)}), false);
                    ChannelDataAccessor.iterateChannelData(heldStack).map(e -> (String)e.getKey() + ": " + e.getValue()).map(Component::m_237113_).forEach(c -> player.m_5661_((Component)c, false));
                }
                yield 1;
            }
        };
    }

    static enum SubCommand {
        GET,
        SET,
        UNSET,
        WIPE,
        GETALL;

    }
}

