/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import java.util.HashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IMultiblockInfoContainer<T> {
    public static final HashMap<String, IMultiblockInfoContainer<?>> MULTIBLOCK_MAP = new HashMap();

    public static <T extends BlockEntity> void registerTileClass(Class<T> clazz, IMultiblockInfoContainer<?> info) {
        MULTIBLOCK_MAP.put(clazz.getCanonicalName(), info);
    }

    public static <T> IMultiblockInfoContainer<T> get(Class<?> tClass) {
        return MULTIBLOCK_MAP.get(tClass.getCanonicalName());
    }

    public static boolean contains(Class<?> tClass) {
        return MULTIBLOCK_MAP.containsKey(tClass.getCanonicalName());
    }

    public void construct(ItemStack var1, boolean var2, T var3, ExtendedFacing var4);

    public int survivalConstruct(ItemStack var1, int var2, ISurvivalBuildEnvironment var3, T var4, ExtendedFacing var5);

    public String[] getDescription(ItemStack var1);

    default public ISurvivalConstructable toConstructable(final T tileEntity, final ExtendedFacing aSide) {
        return new ISurvivalConstructable(){

            @Override
            public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
                return IMultiblockInfoContainer.this.survivalConstruct(stackSize, elementBudget, env, tileEntity, aSide);
            }

            @Override
            public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, ServerPlayer actor) {
                return IMultiblockInfoContainer.this.survivalConstruct(stackSize, elementBudget, ISurvivalBuildEnvironment.create(source, (Player)actor), tileEntity, aSide);
            }

            @Override
            public void construct(ItemStack stackSize, boolean hintsOnly) {
                IMultiblockInfoContainer.this.construct(stackSize, hintsOnly, tileEntity, aSide);
            }

            @Override
            public String[] getStructureDescription(ItemStack stackSize) {
                return IMultiblockInfoContainer.this.getDescription(stackSize);
            }
        };
    }
}

