/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.StructureLibConfig;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.util.PlatformUtils;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ConstructableUtility {
    private static final WeakHashMap<ServerPlayer, Long> lastUse = new WeakHashMap();
    private static long clientSideLastUse = 0L;

    private ConstructableUtility() {
    }

    public static boolean handle(ItemStack aStack, Player aPlayer, Level aLevel, int aX, int aY, int aZ, int aSide) {
        StructureLibAPI.startHinting(aLevel);
        boolean ret = ConstructableUtility.handle0(aStack, aPlayer, aLevel, aX, aY, aZ, aSide);
        StructureLibAPI.endHinting(aLevel);
        return ret;
    }

    private static boolean handle0(ItemStack aStack, Player aPlayer, Level aLevel, int aX, int aY, int aZ, int aSide) {
        BlockEntity tBlockEntity = aLevel.m_7702_(new BlockPos(aX, aY, aZ));
        if (tBlockEntity == null || PlatformUtils.INSTANCE.isFakePlayer(aPlayer)) {
            return aPlayer instanceof ServerPlayer;
        }
        if (aPlayer instanceof ServerPlayer) {
            if (!aPlayer.m_6144_()) {
                return true;
            }
            long timePast = System.currentTimeMillis() - ConstructableUtility.getLastUseMilis(aPlayer);
            if (timePast < (long)StructureLibConfig.AUTO_PLACE_INTERVAL.get()) {
                aPlayer.m_5661_((Component)Component.m_237110_((String)"item.structurelib.constructableTrigger.too_fast", (Object[])new Object[]{(long)StructureLibConfig.AUTO_PLACE_INTERVAL.get() - timePast}), false);
                return true;
            }
        } else if (!StructureLib.isCurrentPlayer(aPlayer)) {
            return false;
        }
        IConstructable constructable = null;
        if (tBlockEntity instanceof IConstructableProvider) {
            constructable = ((IConstructableProvider)tBlockEntity).getConstructable();
        } else if (tBlockEntity instanceof IConstructable) {
            constructable = (IConstructable)tBlockEntity;
        } else if (IMultiblockInfoContainer.contains(tBlockEntity.getClass())) {
            ExtendedFacing facing = tBlockEntity instanceof IAlignment ? ((IAlignment)tBlockEntity).getExtendedFacing() : ExtendedFacing.of(Direction.m_122376_((int)aSide));
            constructable = IMultiblockInfoContainer.get(tBlockEntity.getClass()).toConstructable(tBlockEntity, facing);
        }
        if (constructable == null) {
            return false;
        }
        if (aPlayer instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)aPlayer;
            if (aPlayer.m_7500_()) {
                constructable.construct(aStack, false);
            } else if (constructable instanceof ISurvivalConstructable) {
                int built = ((ISurvivalConstructable)constructable).survivalConstruct(aStack, StructureLibConfig.AUTO_PLACE_BUDGET.get(), ISurvivalBuildEnvironment.create(IItemSource.fromPlayer(playerMP), (Player)playerMP));
                if (built > 0) {
                    playerMP.m_5661_((Component)Component.m_237110_((String)"structurelib.autoplace.built_stat", (Object[])new Object[]{built}), false);
                } else if (built == -1) {
                    playerMP.m_5661_((Component)Component.m_237115_((String)"structurelib.autoplace.complete"), false);
                }
                ConstructableUtility.setLastUseMilis(aPlayer);
            } else {
                playerMP.m_5661_((Component)Component.m_237115_((String)"structurelib.autoplace.error.not_enabled"), false);
            }
            return true;
        }
        constructable.construct(aStack, true);
        if (System.currentTimeMillis() - ConstructableUtility.getLastUseMilis(aPlayer) >= 300L) {
            StructureLib.addClientSideChatMessages(constructable.getStructureDescription(aStack));
        }
        ConstructableUtility.setLastUseMilis(aPlayer);
        return false;
    }

    private static void setLastUseMilis(Player aPlayer) {
        if (!(aPlayer instanceof ServerPlayer)) {
            clientSideLastUse = System.currentTimeMillis();
        } else {
            lastUse.put((ServerPlayer)aPlayer, System.currentTimeMillis());
        }
    }

    private static long getLastUseMilis(Player aPlayer) {
        if (!(aPlayer instanceof ServerPlayer)) {
            return clientSideLastUse;
        }
        return lastUse.getOrDefault(aPlayer, 0L);
    }
}

