/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.CommonProxy;
import com.gtnewhorizon.structurelib.IStructureCompat;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibConfig;
import com.gtnewhorizon.structurelib.gui.ContainerConfigureChannels;
import com.gtnewhorizon.structurelib.gui.GuiScreenConfigureChannels;
import com.gtnewhorizon.structurelib.net.SetChannelDataMessage;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ClientProxy
extends CommonProxy {
    private static final short[] RGBA_NO_TINT = new short[]{255, 255, 255, 255};
    private static final short[] RGBA_RED_TINT = new short[]{255, 128, 128, 0};
    private static final Map<HintParticleInfo, HintGroup> allHints = new HashMap<HintParticleInfo, HintGroup>();
    private static final List<HintGroup> allGroups = new ArrayList<HintGroup>();
    public static int HOLOGRAM_LIFETIME = 200;
    private static HintGroup currentHints;
    private static final List<HintParticleInfo> allHintsForRender;
    private static final BlockPos.MutableBlockPos lastPlayerPos;
    private static boolean allHintsDirty;
    private static int renderThrough;
    private static final Map<Object, Long> localThrottleMap;

    @Override
    public void hintParticleTinted(Level w, int x, int y, int z, TextureAtlasSprite[] icons, short[] RGBa) {
        HintGroup dupe;
        this.ensureHinting();
        HintParticleInfo info = new HintParticleInfo(w, x, y, z, icons, RGBa);
        if (StructureLibConfig.REMOVE_COLLIDING.get() && (dupe = allHints.get(info)) != null && dupe != currentHints) {
            allGroups.remove(dupe);
            ClientProxy.removeGroup(dupe);
        }
        allHints.put(info, currentHints);
        currentHints.getHints().add(info);
        allHintsDirty = true;
    }

    @Override
    public void hintParticleTinted(Level w, int x, int y, int z, Block block, short[] RGBa) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createTextureAtlasSpriteFromBlock(block), RGBa);
    }

    @Override
    public void hintParticle(Level w, int x, int y, int z, TextureAtlasSprite[] icons) {
        this.hintParticleTinted(w, x, y, z, icons, RGBA_NO_TINT);
    }

    @Override
    public void hintParticle(Level w, int x, int y, int z, Block block) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createTextureAtlasSpriteFromBlock(block), RGBA_NO_TINT);
    }

    @Override
    public boolean updateHintParticleTint(Player player, Level w, int x, int y, int z, short[] rgBa) {
        if (player instanceof ServerPlayer) {
            return super.updateHintParticleTint(player, w, x, y, z, rgBa);
        }
        if (player != this.getCurrentPlayer()) {
            return false;
        }
        HintParticleInfo hint = ClientProxy.getHintParticleInfo(w, x, y, z);
        if (hint == null) {
            return false;
        }
        hint.setTint(rgBa);
        return true;
    }

    private static HintParticleInfo getHintParticleInfo(Level w, int x, int y, int z) {
        HintParticleInfo info = new HintParticleInfo(w, x, y, z, null, null);
        HintGroup existing = allHints.get(info);
        if (existing != null) {
            for (HintParticleInfo hint : existing.getHints()) {
                if (!hint.equals(info)) continue;
                return hint;
            }
        }
        return null;
    }

    @Override
    public boolean markHintParticleError(Player player, Level w, int x, int y, int z) {
        if (player instanceof ServerPlayer) {
            return super.markHintParticleError(player, w, x, y, z);
        }
        if (player != this.getCurrentPlayer()) {
            return false;
        }
        HintParticleInfo hint = ClientProxy.getHintParticleInfo(w, x, y, z);
        if (hint == null) {
            return false;
        }
        hint.setTint(RGBA_RED_TINT);
        hint.setRenderThrough();
        return true;
    }

    @Override
    public void addThrottledChat(Object throttleKey, Player player, Component text, short intervalRequired, boolean forceUpdateLastSend) {
        if (player instanceof ServerPlayer) {
            super.addThrottledChat(throttleKey, player, text, intervalRequired, forceUpdateLastSend);
        } else if (player != null) {
            ClientProxy.addThrottledChat(throttleKey, player, text, intervalRequired, forceUpdateLastSend, localThrottleMap);
        }
    }

    static void removeGroup(HintGroup group) {
        for (HintParticleInfo hintParticleInfo : group.getHints()) {
            allHints.remove(hintParticleInfo);
            if (!hintParticleInfo.renderThrough) continue;
            --renderThrough;
        }
        allHintsDirty = true;
    }

    private static TextureAtlasSprite[] createTextureAtlasSpriteFromBlock(Block block) {
        TextureAtlasSprite[] ret = new TextureAtlasSprite[6];
        for (int i = 0; i < 6; ++i) {
        }
        return ret;
    }

    @Override
    public void addClientSideChatMessages(String ... messages) {
        for (String s : messages) {
            this.getCurrentPlayer().m_5661_((Component)Component.m_237113_((String)s), false);
        }
    }

    @Override
    public Player getCurrentPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean isCurrentPlayer(Player player) {
        return player == Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void startHinting(Level w) {
        if (!w.f_46443_) {
            return;
        }
        if (currentHints != null) {
            this.endHinting(w);
        }
        currentHints = new HintGroup();
    }

    private void ensureHinting() {
        if (currentHints == null) {
            currentHints = new HintGroup();
        }
    }

    @Override
    public void endHinting(Level w) {
        if (!w.f_46443_ || currentHints == null) {
            return;
        }
        while (!allGroups.isEmpty() && allGroups.size() >= StructureLibConfig.MAX_COEXISTING.get()) {
            allGroups.remove(0);
        }
        if (!currentHints.getHints().isEmpty()) {
            allGroups.add(currentHints);
        }
        currentHints.setCreationTime(this.getCurrentPlayer().f_19797_);
        currentHints = null;
    }

    @Override
    public long getOverworldTime() {
        return Minecraft.m_91087_().f_91073_.m_46467_();
    }

    @Override
    public void uploadChannels(ItemStack trigger, InteractionHand hand) {
        StructureLib.CHANNEL.sendToServer((Packet)new SetChannelDataMessage(trigger, hand));
    }

    @Override
    public void preInit() {
        MenuScreens.m_96206_(ContainerConfigureChannels.getMenuType(), GuiScreenConfigureChannels::new);
    }

    static void markTextureUsed(TextureAtlasSprite icon) {
        if (StructureLib.COMPAT instanceof IStructureCompat) {
            ((IStructureCompat)StructureLib.COMPAT).markTextureUsed(icon);
        }
    }

    public static void onLevelLoad(LevelAccessor level) {
        if (level.m_5776_()) {
            allHintsForRender.clear();
            allGroups.clear();
            lastPlayerPos.m_142448_(Integer.MIN_VALUE);
            renderThrough = 0;
            localThrottleMap.clear();
        }
    }

    static {
        allHintsForRender = new ArrayList<HintParticleInfo>(10000);
        lastPlayerPos = new BlockPos.MutableBlockPos(0, Integer.MIN_VALUE, 0);
        allHintsDirty = false;
        localThrottleMap = new HashMap<Object, Long>();
    }

    private static class HintParticleInfo {
        private final Level w;
        private final int x;
        private final int y;
        private final int z;
        private final TextureAtlasSprite[] icons;
        private short[] tint;
        private boolean renderThrough;
        private final long creationTime = System.currentTimeMillis();

        public HintParticleInfo(Level w, int x, int y, int z, TextureAtlasSprite[] icons, short[] tint) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
            this.icons = icons;
            this.tint = tint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HintParticleInfo)) {
                return false;
            }
            HintParticleInfo that = (HintParticleInfo)o;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }

        public void setTint(short[] tint) {
            this.tint = tint;
        }

        public void setRenderThrough() {
            if (!this.renderThrough) {
                ++renderThrough;
                allHintsDirty = true;
            }
            this.renderThrough = true;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public double getSquareDistanceTo(Vec3 point) {
            return point.m_82531_((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
        }
    }

    private static class HintGroup {
        private final List<HintParticleInfo> hints = new LinkedList<HintParticleInfo>();
        private int creationTime = -1;

        private HintGroup() {
        }

        public List<HintParticleInfo> getHints() {
            return this.hints;
        }

        public void setCreationTime(int creationTime) {
            this.creationTime = creationTime;
        }

        public int getCreationTime() {
            return this.creationTime;
        }
    }

    public static class ForgeEventHandler {
    }

    public static class FMLEventHandler {
        private void resetPlayerLocation() {
            lastPlayerPos.m_122169_(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_(), Minecraft.m_91087_().f_91074_.m_20189_());
        }
    }
}

