/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSettings;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.util.PlatformUtils;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.function.TriFunction;

public class PlatformUtilsImpl
implements PlatformUtils {
    @Override
    public boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer;
    }

    @Override
    public boolean isServer() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public void registerBlock(ResourceLocation id, Block block) {
        block.setRegistryName(id);
        BlockItem blockItem = new BlockItem(block, new Item.Properties().tab(StructureLib.getCreativeTab()));
        blockItem.setRegistryName(id);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)blockItem);
    }

    @Override
    public void registerItem(ResourceLocation id, Item item) {
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    @Override
    public void openGui(ServerPlayer player, MenuProvider containerSupplier, Consumer<FriendlyByteBuf> extraDataWriter) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)containerSupplier, extraDataWriter);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> create(TriFunction<Integer, Inventory, FriendlyByteBuf, T> factory) {
        return IForgeMenuType.create((arg_0, arg_1, arg_2) -> factory.apply(arg_0, arg_1, arg_2));
    }

    @Override
    public ConfigHandler createConfig(String modid, Config config) {
        return CarbonConfig.CONFIGS.createConfig(config);
    }

    @Override
    public ConfigHandler createConfig(String modId, Config config, ConfigSettings configSettings) {
        return CarbonConfig.CONFIGS.createConfig(config, configSettings);
    }
}

