/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class InventoryIterable<Inv extends Container>
implements Iterable<ItemStack> {
    private final Inv inv;
    private final int maxSlot;

    public InventoryIterable(Inv inv) {
        this(inv, -1);
    }

    InventoryIterable(Inv inv, int maxSlot) {
        this.inv = inv;
        this.maxSlot = maxSlot;
    }

    public Inv getInventory() {
        return this.inv;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int ptr = 0;

            @Override
            public boolean hasNext() {
                return this.ptr < InventoryIterable.this.inv.getContainerSize() && (InventoryIterable.this.maxSlot == -1 || this.ptr < InventoryIterable.this.maxSlot);
            }

            @Override
            public ItemStack next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return InventoryIterable.this.inv.getItem(this.ptr++);
            }

            @Override
            public void remove() {
                InventoryIterable.this.inv.setItem(this.ptr - 1, ItemStack.EMPTY);
            }
        };
    }
}

