/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureWalker;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

class SurvivalBuildStructureWalker<T>
implements IStructureWalker<T> {
    final T object;
    final ItemStack trigger;
    private final int elementBudget;
    private final ISurvivalBuildEnvironment params;
    private final boolean check;
    private int built = -1;
    private final AutoPlaceEnvironment env;

    public SurvivalBuildStructureWalker(T object, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment params, IStructureDefinition<?> definition, String piece, ExtendedFacing facing, int[] baseOffsetABC, boolean check) {
        this.object = object;
        this.trigger = trigger;
        this.elementBudget = elementBudget;
        this.params = params;
        this.check = check;
        this.env = new AutoPlaceEnvironment(params.getActor(), c -> params.getActor().sendMessage(c, params.getActor().getUUID()), definition, piece, facing, baseOffsetABC);
    }

    @Override
    public boolean visit(IStructureElement<T> element, Level world, int x, int y, int z, int a, int b, int c) {
        this.env.offsetABC[0] = a;
        this.env.offsetABC[1] = b;
        this.env.offsetABC[2] = c;
        this.env.setSource(this.params.getSource());
        IStructureElement.PlaceResult placeResult = element.survivalPlaceBlock(this.object, world, x, y, z, this.trigger, this.env);
        if (placeResult != IStructureElement.PlaceResult.SKIP && this.built == -1) {
            this.built = 0;
        }
        switch (placeResult) {
            case SKIP: {
                return true;
            }
            case ACCEPT: {
                if (this.check) {
                    element.check(this.object, world, x, y, z);
                }
                return ++this.built < this.elementBudget;
            }
            case REJECT: {
                StructureLibAPI.markHintParticleError(this.params.getActor(), world, x, y, z);
                return false;
            }
            case ACCEPT_STOP: {
                if (this.check) {
                    element.check(this.object, world, x, y, z);
                }
                ++this.built;
            }
            case STOP: {
                return false;
            }
        }
        throw new NullPointerException();
    }

    public int getBuilt() {
        return this.built;
    }
}

