/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.Registry;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.ChatThrottleKey;
import com.gtnewhorizon.structurelib.structure.IBlockPosConsumer;
import com.gtnewhorizon.structurelib.structure.ICustomBlockSetting;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureCallback;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementChain;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.IStructureElementDeferred;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.IStructureNavigate;
import com.gtnewhorizon.structurelib.structure.IStructureWalker;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.IWithExtendedContext;
import com.gtnewhorizon.structurelib.structure.LazyStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureElement_Bridge;
import com.gtnewhorizon.structurelib.structure.adders.IBlockAdder;
import com.gtnewhorizon.structurelib.structure.adders.ITileAdder;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class StructureUtility {
    private static final String NICE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz=|!@#$%&()[]{};:<>/?_,.*^'`";
    private static final Map<Vec3i, IStructureNavigate> STEP = new HashMap<Vec3i, IStructureNavigate>();
    private static final IStructureElement AIR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, Level world, int x, int y, int z) {
            return world.getBlockState(new BlockPos(x, y, z)).isAir();
        }

        @Override
        public boolean spawnHint(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, Blocks.AIR);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            world.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 2);
            return false;
        }

        @Override
        @Deprecated
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            world.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 2);
            return IStructureElement.PlaceResult.ACCEPT;
        }
    };
    private static final IStructureElement NOT_AIR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, Level world, int x, int y, int z) {
            return !world.getBlockState(new BlockPos(x, y, z)).isAir();
        }

        @Override
        public boolean spawnHint(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, Blocks.AIR);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            world.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 2);
            return true;
        }

        @Override
        public IStructureElement.BlocksToPlace getBlocksToPlace(Object o, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create(Objects::nonNull);
        }

        @Override
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (env.getSource().takeOne(new ItemStack((ItemLike)Blocks.COBBLESTONE), false)) {
                world.setBlock(new BlockPos(x, y, z), Blocks.COBBLESTONE.defaultBlockState(), 2);
            }
            return IStructureElement.PlaceResult.REJECT;
        }
    };
    private static final IStructureElement ERROR = new StructureElement_Bridge(){

        @Override
        public boolean check(Object t, Level world, int x, int y, int z) {
            return false;
        }

        @Override
        public boolean spawnHint(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle(world, x, y, z, Blocks.AIR);
            return true;
        }

        @Override
        public boolean placeBlock(Object o, Level world, int x, int y, int z, ItemStack trigger) {
            return true;
        }

        @Override
        public IStructureElement.PlaceResult survivalPlaceBlock(Object o, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.PlaceResult.REJECT;
        }
    };

    private StructureUtility() {
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, Level world, int x, int y, int z, IItemSource s, ServerPlayer actor) {
        return StructureUtility.survivalPlaceBlock(block, world, x, y, z, s, actor);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, Level world, int x, int y, int z, IItemSource s, Player actor) {
        return StructureUtility.survivalPlaceBlock(block, world, x, y, z, s, actor, null);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, Level world, int x, int y, int z, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
        return StructureUtility.survivalPlaceBlock(block, world, x, y, z, s, (Player)actor, chatter);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(Block block, Level world, int x, int y, int z, IItemSource s, Player actor, Consumer<Component> chatter) {
        if (block == null) {
            throw new NullPointerException();
        }
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        Item BlockItem = block.asItem();
        if (!s.takeOne(new ItemStack((ItemLike)BlockItem, 1), false)) {
            if (chatter != null) {
                chatter.accept((Component)new TranslatableComponent("structurelib.autoplace.error.no_simple_block", new Object[]{new ItemStack((ItemLike)BlockItem, 1).getDisplayName()}));
            }
            return IStructureElement.PlaceResult.REJECT;
        }
        if (block instanceof ICustomBlockSetting) {
            ICustomBlockSetting block2 = (ICustomBlockSetting)block;
            block2.setBlock(world, x, y, z);
        } else {
            world.setBlock(new BlockPos(x, y, z), block.defaultBlockState(), 2);
        }
        return IStructureElement.PlaceResult.ACCEPT;
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, CompoundTag tag, boolean assumeStackPresent, Level world, int x, int y, int z, IItemSource s, ServerPlayer actor) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, (Player)actor);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, CompoundTag tag, boolean assumeStackPresent, Level world, int x, int y, int z, IItemSource s, Player actor) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, actor, null);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, CompoundTag tag, boolean assumeStackPresent, Level world, int x, int y, int z, IItemSource s, ServerPlayer actor, @Nullable Consumer<Component> chatter) {
        return StructureUtility.survivalPlaceBlock(stack, nbtMode, tag, assumeStackPresent, world, x, y, z, s, (Player)actor, chatter);
    }

    public static IStructureElement.PlaceResult survivalPlaceBlock(ItemStack stack, ItemStackPredicate.NBTMode nbtMode, CompoundTag tag, boolean assumeStackPresent, Level world, int x, int y, int z, IItemSource s, Player actor, @Nullable Consumer<Component> chatter) {
        if (stack.isEmpty()) {
            throw new NullPointerException();
        }
        if (stack.getCount() != 1) {
            throw new IllegalArgumentException();
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            throw new IllegalArgumentException();
        }
        BlockItem blockItem = (BlockItem)item;
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!assumeStackPresent && !s.takeOne(stack, true)) {
            if (chatter != null) {
                chatter.accept((Component)new TranslatableComponent("structurelib.autoplace.error.no_item_stack", new Object[]{stack.getDisplayName()}));
            }
            return IStructureElement.PlaceResult.REJECT;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!blockItem.place(new BlockPlaceContext(actor, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false))).consumesAction()) {
            return IStructureElement.PlaceResult.REJECT;
        }
        if (!s.takeOne(stack, false)) {
            world.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 2);
        }
        return IStructureElement.PlaceResult.ACCEPT;
    }

    public static <T> IStructureElement<T> isAir() {
        return AIR;
    }

    public static <T> IStructureElement<T> notAir() {
        return NOT_AIR;
    }

    public static <T> IStructureElement<T> error() {
        return ERROR;
    }

    public static <T> IStructureElementNoPlacement<T> ofHint(final int dots) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, Registry.getHint(dots));
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<TextureAtlasSprite[]> icons) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, (TextureAtlasSprite[])icons.get());
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHintDeferred(final Supplier<TextureAtlasSprite[]> icons, final short[] RGBa) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticleTinted(world, x, y, z, (TextureAtlasSprite[])icons.get(), RGBa);
                return false;
            }
        };
    }

    public static <T, TIER> IStructureElementCheckOnly<T> ofBlocksTiered(ITierConverter<TIER> tierExtractor, @Nullable TIER notSet, BiConsumer<T, TIER> setter, Function<T, TIER> getter) {
        if (tierExtractor == null) {
            throw new IllegalArgumentException();
        }
        if (setter == null) {
            throw new IllegalArgumentException();
        }
        if (getter == null) {
            throw new IllegalArgumentException();
        }
        return (t, world, x, y, z) -> {
            Block block = world.getBlockState(new BlockPos(x, y, z)).getBlock();
            Object tier = tierExtractor.convert(block);
            if (tier == null) {
                return false;
            }
            Object current = getter.apply(t);
            if (Objects.equals(notSet, current)) {
                if (Objects.equals(notSet, tier)) {
                    if (StructureLib.PANIC_MODE) {
                        throw new AssertionError((Object)("tierExtractor should never return notSet: " + notSet));
                    }
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("tierExtractor should never return notSet: {}", notSet, (Object)new Throwable());
                    StructureLib.LOGGER.error("#########################################");
                    StructureLib.LOGGER.error("#########################################");
                }
                setter.accept(t, tier);
                return true;
            }
            return Objects.equals(current, tier);
        };
    }

    public static <T, TIER> IStructureElement<T> ofBlocksTiered(final ITierConverter<TIER> tierExtractor, @Nullable List<Block> allKnownTiers, @Nullable TIER notSet, BiConsumer<T, TIER> setter, Function<T, TIER> getter) {
        List<Object> hints;
        List<Object> list = hints = allKnownTiers == null ? Collections.emptyList() : allKnownTiers;
        if (hints.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException();
        }
        final IStructureElementCheckOnly<T> check = StructureUtility.ofBlocksTiered(tierExtractor, notSet, setter, getter);
        return new StructureElement_Bridge<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return check.check(t, world, x, y, z);
            }

            private Block getHint(ItemStack trigger) {
                return (Block)hints.get(Math.min(Math.max(trigger.getCount(), 1), hints.size()) - 1);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                Block hint = this.getHint(trigger);
                if (hint == null) {
                    return false;
                }
                StructureLibAPI.hintParticle(world, x, y, z, hint);
                return true;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                Block hint = this.getHint(trigger);
                if (hint == null) {
                    return false;
                }
                if (hint instanceof ICustomBlockSetting) {
                    ICustomBlockSetting block = (ICustomBlockSetting)hint;
                    block.setBlock(world, x, y, z);
                } else {
                    world.setBlock(new BlockPos(x, y, z), hint.defaultBlockState(), 2);
                }
                return true;
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                Block hint = this.getHint(trigger);
                return IStructureElement.BlocksToPlace.create(hint);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                Block hint = this.getHint(trigger);
                if (hint == null) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                Block block = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                Object tier = tierExtractor.convert(block);
                if (Objects.equals(tier, tierExtractor.convert(hint))) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock(hint, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockRegistryName(final String modid, final String registryName) {
        if (StringUtils.isBlank((CharSequence)registryName)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((CharSequence)modid)) {
            throw new IllegalArgumentException();
        }
        return new StructureElement_Bridge<T>(){
            private Block block;

            private Block getBlock() {
                if (this.block == null) {
                    this.block = (Block)net.minecraft.core.Registry.BLOCK.get(new ResourceLocation(modid, registryName));
                }
                return this.block;
            }

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return world.getBlockState(new BlockPos(x, y, z)).getBlock() == this.getBlock();
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().spawnHint(t, world, x, y, z, trigger);
                }
                StructureLibAPI.hintParticle(world, x, y, z, this.getBlock());
                return true;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().placeBlock(t, world, x, y, z, trigger);
                }
                world.setBlock(new BlockPos(x, y, z), this.getBlock().defaultBlockState(), 2);
                return true;
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.getBlock() == null) {
                    return StructureUtility.error().getBlocksToPlace(t, world, x, y, z, trigger, env);
                }
                return IStructureElement.BlocksToPlace.create(this.getBlock());
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.getBlock() == null) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock(this.getBlock(), world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockRegistryName(final String modid, final String registryName, final IStructureElement<T> fallback) {
        if (StringUtils.isBlank((CharSequence)registryName)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((CharSequence)modid)) {
            throw new IllegalArgumentException();
        }
        if (fallback == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){
            private Block block;
            private boolean initialized;

            private boolean init() {
                if (!this.initialized) {
                    this.block = (Block)net.minecraft.core.Registry.BLOCK.get(new ResourceLocation(modid, registryName));
                    this.initialized = true;
                }
                return this.block != null;
            }

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                if (this.init()) {
                    return world.getBlockState(new BlockPos(x, y, z)).getBlock() != this.block;
                }
                return fallback.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                if (this.init()) {
                    StructureLibAPI.hintParticle(world, x, y, z, this.block);
                    return true;
                }
                return fallback.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                if (this.init()) {
                    world.setBlock(new BlockPos(x, y, z), this.block.defaultBlockState(), 2);
                    return true;
                }
                return fallback.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.init()) {
                    return IStructureElement.BlocksToPlace.create(this.block);
                }
                return fallback.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.init()) {
                    return StructureUtility.survivalPlaceBlock(this.block, world, x, y, z, s, actor, chatter);
                }
                return fallback.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (this.init()) {
                    return StructureUtility.survivalPlaceBlock(this.block, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
                }
                return fallback.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(final Block block, final Block hintBlock) {
        if (block == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                return block == worldBlock;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock);
                return true;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockHint(Block block) {
        return StructureUtility.ofBlockHint(block, block);
    }

    public static <T> IStructureElementNoPlacement<T> ofBlockAdderHint(final IBlockAdder<T> iBlockAdder, final Block hintBlock) {
        if (iBlockAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                return iBlockAdder.apply(t, worldBlock);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(final Block block, final Block defaultBlock) {
        if (block == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (block instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){

                @Override
                public boolean check(T t, Level world, int x, int y, int z) {
                    Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                    return block == worldBlock;
                }

                @Override
                public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock);
                    return true;
                }

                @Override
                public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    return IStructureElement.BlocksToPlace.create(block);
                }
            };
        }
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                return block == worldBlock;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                world.setBlock(new BlockPos(x, y, z), defaultBlock.defaultBlockState(), 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock);
                return true;
            }

            @Override
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create(block);
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(Block block) {
        return StructureUtility.ofBlock(block, block);
    }

    public static <T> IStructureElement<T> ofBlock(final TagKey<Block> blockTag) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return world.getBlockState(new BlockPos(x, y, z)).is(blockTag);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return false;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlock(final TagKey<Block> blockTag, final Block hint) {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return world.getBlockState(new BlockPos(x, y, z)).is(blockTag);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hint);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockAdder(final IBlockAdder<T> iBlockAdder, final Block defaultBlock) {
        if (iBlockAdder == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (defaultBlock instanceof ICustomBlockSetting) {
            return new StructureElement_Bridge<T>(){

                @Override
                public boolean check(T t, Level world, int x, int y, int z) {
                    Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                    return iBlockAdder.apply(t, worldBlock);
                }

                @Override
                public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z);
                    return true;
                }

                @Override
                public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle(world, x, y, z, defaultBlock);
                    return true;
                }

                @Override
                @Deprecated
                public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    if (world.getBlockState(new BlockPos(x, y, z)).getBlock() == defaultBlock) {
                        return IStructureElement.PlaceResult.SKIP;
                    }
                    return StructureUtility.survivalPlaceBlock(defaultBlock, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
                }
            };
        }
        return new StructureElement_Bridge<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                Block worldBlock = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                return iBlockAdder.apply(t, worldBlock);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                world.setBlock(new BlockPos(x, y, z), defaultBlock.defaultBlockState(), 2);
                return true;
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, defaultBlock);
                return true;
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (world.getBlockState(new BlockPos(x, y, z)).getBlock() == defaultBlock) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock(defaultBlock, world, x, y, z, env.getSource(), env.getActor(), env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofBlockAdder(IBlockAdder<T> iBlockAdder, int dots) {
        return StructureUtility.ofBlockAdder(iBlockAdder, Registry.getHint(dots));
    }

    public static <T> IStructureElementNoPlacement<T> ofTileAdder(final ITileAdder<T> iTileAdder, final Block hintBlock) {
        if (iTileAdder == null || hintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                BlockEntity tileEntity = world.getBlockEntity(new BlockPos(x, y, z));
                return iTileAdder.apply(t, tileEntity);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock);
                return true;
            }
        };
    }

    public static <T, E> IStructureElementNoPlacement<T> ofSpecificTileAdder(final BiPredicate<T, E> iTileAdder, final Class<E> tileClass, final Block hintBlock) {
        if (iTileAdder == null || hintBlock == null || tileClass == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                BlockEntity tileEntity = world.getBlockEntity(new BlockPos(x, y, z));
                return tileClass.isInstance(tileEntity) && iTileAdder.test(t, tileClass.cast(tileEntity));
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle(world, x, y, z, hintBlock);
                return true;
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementPass(final IStructureCallback<T, B> onCheckPass, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (check) {
                    onCheckPass.accept(element, t, world, x, y, z);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                element.onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                element.onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementFail(final IStructureCallback<T, B> onFail, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (!check) {
                    onFail.accept(element, t, world, x, y, z);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                element.onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                element.onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <B extends IStructureElement<T>, T> IStructureElement<T> onElementFailAndPass(final IStructureCallback<T, B> onFail, final IStructureCallback<T, B> onPass, final B element) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                boolean check = element.check(t, world, x, y, z);
                if (!check) {
                    onFail.accept(element, t, world, x, y, z);
                } else {
                    onPass.accept(element, t, world, x, y, z);
                }
                return check;
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return element.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return element.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                element.onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                element.onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T> IStructureElement<T> onlyIf(Predicate<? super T> predicate, IStructureElement<? super T> downstream) {
        return StructureUtility.onlyIf(predicate, downstream, IStructureElement.PlaceResult.SKIP);
    }

    public static <T> IStructureElement<T> onlyIf(final Predicate<? super T> predicate, final IStructureElement<? super T> downstream, final IStructureElement.PlaceResult placeResultWhenDisabled) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return predicate.test(t) && downstream.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return predicate.test(t) && downstream.spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return predicate.test(t) && downstream.placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (predicate.test(t)) {
                    return downstream.getBlocksToPlace(t, world, x, y, z, trigger, env);
                }
                return IStructureElement.BlocksToPlace.createEmpty();
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                if (predicate.test(t)) {
                    return downstream.survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
                }
                return placeResultWhenDisabled;
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (predicate.test(t)) {
                    return downstream.survivalPlaceBlock(t, world, x, y, z, trigger, env);
                }
                return placeResultWhenDisabled;
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                downstream.onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                if (!predicate.test(t)) {
                    return;
                }
                downstream.onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    @SafeVarargs
    public static <T> IStructureElementChain<T> ofChain(IStructureElement<T> ... elementChain) {
        if (elementChain == null || elementChain.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IStructureElement<T> iStructureElement : elementChain) {
            if (iStructureElement != null) continue;
            throw new IllegalArgumentException();
        }
        return () -> elementChain;
    }

    public static <T> IStructureElementChain<T> ofChain(List<IStructureElement<T>> elementChain) {
        return StructureUtility.ofChain(elementChain.toArray(new IStructureElement[0]));
    }

    public static <CTX, T extends IWithExtendedContext<CTX>> IStructureElement<T> withContext(final IStructureElement<CTX> elem) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return elem.check(t.getCurrentContext(), world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return elem.spawnHint(t.getCurrentContext(), world, x, y, z, trigger);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return elem.placeBlock(t.getCurrentContext(), world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return elem.getBlocksToPlace(t.getCurrentContext(), world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return elem.survivalPlaceBlock(t.getCurrentContext(), world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return elem.survivalPlaceBlock(t.getCurrentContext(), world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                elem.onStructureFail(t.getCurrentContext(), world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                elem.onStructureSuccess(t.getCurrentContext(), world, x, y, z);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> lazy(Supplier<IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new LazyStructureElement<Object>(t -> (IStructureElement)to.get());
    }

    public static <T> IStructureElementDeferred<T> lazy(Function<T, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new LazyStructureElement<T>(to);
    }

    public static <T> IStructureElementDeferred<T> defer(final Supplier<IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return ((IStructureElement)to.get()).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.get()).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.get()).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return ((IStructureElement)to.get()).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.get()).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.get()).onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.get()).onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t)).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return ((IStructureElement)to.apply(t)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.apply(t)).onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.apply(t)).onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(map::get));
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(key -> map.getOrDefault(key, defaultElem)));
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(i -> array[i]));
    }

    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElementDeferred<T> defer(final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return ((IStructureElement)to.apply(t, ItemStack.EMPTY)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.apply(t, ItemStack.EMPTY)).onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                ((IStructureElement)to.apply(t, ItemStack.EMPTY)).onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(map::get));
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(key -> map.getOrDefault(key, defaultElem)));
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractor.andThen(i -> array[i]));
    }

    public static <T> IStructureElementDeferred<T> defer(BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.defer(keyExtractor.andThen(array::get));
    }

    public static <T> IStructureElementDeferred<T> defer(final Function<T, IStructureElement<T>> toCheck, final BiFunction<T, ItemStack, IStructureElement<T>> to) {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementDeferred<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return ((IStructureElement)toCheck.apply(t)).check(t, world, x, y, z);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).placeBlock(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return ((IStructureElement)to.apply(t, trigger)).spawnHint(t, world, x, y, z, trigger);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return ((IStructureElement)to.apply(t, trigger)).survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                ((IStructureElement)toCheck.apply(t)).onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                ((IStructureElement)toCheck.apply(t)).onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(map::get), keyExtractor.andThen(map::get));
    }

    public static <T, K> IStructureElementDeferred<T> partitionBy(Function<T, K> keyExtractorCheck, BiFunction<T, ItemStack, K> keyExtractor, Map<K, IStructureElement<T>> map, IStructureElement<T> defaultElem) {
        if (keyExtractor == null || map == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(k -> map.getOrDefault(k, defaultElem)), keyExtractor.andThen(k -> map.getOrDefault(k, defaultElem)));
    }

    @SafeVarargs
    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, IStructureElement<T> ... array) {
        if (keyExtractor == null || array == null) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.defer(keyExtractorCheck.andThen(i -> array[i]), keyExtractor.andThen(i -> array[i]));
    }

    public static <T> IStructureElementDeferred<T> partitionBy(Function<T, Integer> keyExtractorCheck, BiFunction<T, ItemStack, Integer> keyExtractor, List<IStructureElement<T>> array) {
        return StructureUtility.partitionBy(keyExtractorCheck, keyExtractor, array.toArray(new IStructureElement[0]));
    }

    public static <T> IStructureElement<T> withChannel(final String channel, final IStructureElement<T> backing) {
        return new IStructureElement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return backing.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger && StructureLib.getCurrentPlayer() != null) {
                    this.warnNoExplicitSubChannel(StructureLib.getCurrentPlayer());
                }
                return backing.spawnHint(t, world, x, y, z, newTrigger);
            }

            private void warnNoExplicitSubChannel(Player currentPlayer) {
                StructureLibAPI.addThrottledChat(new ChatThrottleKey.NoExplicitChannel(channel), currentPlayer, (Component)new TranslatableComponent("structurelib.autoplace.warning.no_explicit_channel", new Object[]{channel}), (short)100);
            }

            @Override
            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return backing.placeBlock(t, world, x, y, z, ChannelDataAccessor.withChannel(trigger, channel));
            }

            @Override
            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return backing.getBlocksToPlace(t, world, x, y, z, trigger, env);
            }

            @Override
            @Deprecated
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger) {
                    this.warnNoExplicitSubChannel((Player)actor);
                }
                return backing.survivalPlaceBlock(t, world, x, y, z, newTrigger, s, actor, chatter);
            }

            @Override
            public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                ItemStack newTrigger = ChannelDataAccessor.withChannel(trigger, channel);
                if (newTrigger == trigger) {
                    this.warnNoExplicitSubChannel(env.getActor());
                }
                return backing.survivalPlaceBlock(t, world, x, y, z, newTrigger, env);
            }

            @Override
            public void onStructureFail(T t, Level world, int x, int y, int z) {
                backing.onStructureFail(t, world, x, y, z);
            }

            @Override
            public void onStructureSuccess(T t, Level world, int x, int y, int z) {
                backing.onStructureSuccess(t, world, x, y, z);
            }
        };
    }

    public static <T> IStructureNavigate<T> step(int a, int b, int c) {
        return StructureUtility.step(new Vec3i(a, b, c));
    }

    public static <T> IStructureNavigate<T> step(Vec3i step) {
        if (step == null || step.getX() < 0 || step.getY() < 0 || step.getZ() < 0) {
            throw new IllegalArgumentException();
        }
        return STEP.computeIfAbsent(step, vec3 -> {
            if (vec3.getZ() > 0) {
                return StructureUtility.stepC(vec3.getX(), vec3.getY(), vec3.getZ());
            }
            if (vec3.getY() > 0) {
                return StructureUtility.stepB(vec3.getX(), vec3.getY(), vec3.getZ());
            }
            return StructureUtility.stepA(vec3.getX(), vec3.getY(), vec3.getZ());
        });
    }

    private static <T> IStructureNavigate<T> stepA(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepB(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }
        };
    }

    private static <T> IStructureNavigate<T> stepC(final int a, final int b, final int c) {
        return new IStructureNavigate<T>(){

            @Override
            public int getStepA() {
                return a;
            }

            @Override
            public int getStepB() {
                return b;
            }

            @Override
            public int getStepC() {
                return c;
            }

            @Override
            public boolean resetA() {
                return true;
            }

            @Override
            public boolean resetB() {
                return true;
            }
        };
    }

    public static String getPseudoJavaCode(Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, Function<? super BlockEntity, String> tileEntityClassifier, int sizeA, int sizeB, int sizeC, boolean transpose) {
        char c;
        ArrayList blocks = new ArrayList();
        HashSet tiles = new HashSet();
        HashSet specialTiles = new HashSet();
        StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, sizeA, sizeB, sizeC, (w, x, y, z) -> {
            BlockEntity tileEntity = w.getBlockEntity(new BlockPos(x, y, z));
            if (tileEntity == null) {
                Block block = w.getBlockState(new BlockPos(x, y, z)).getBlock();
                if (block != null && block != Blocks.AIR) {
                    blocks.add(block);
                }
            } else {
                String classification = (String)tileEntityClassifier.apply(tileEntity);
                if (classification == null) {
                    tiles.add(tileEntity.getClass());
                } else {
                    specialTiles.add(classification);
                }
            }
        });
        HashMap<Object, Character> map = new HashMap<Object, Character>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        builder.append("\n\nStructure:\n").append("\nBlocks:\n");
        for (Block block : blocks) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(net.minecraft.core.Registry.BLOCK.getKey((Object)block).toString(), Character.valueOf(c));
            builder.append(c).append(" -> ofBlock...(").append(net.minecraft.core.Registry.BLOCK.getKey((Object)block)).append(", ...);\n");
        }
        builder.append("\nTiles:\n");
        for (Object tile : tiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(((Class)tile).getCanonicalName(), Character.valueOf(c));
            builder.append(c).append(" -> ofTileAdder(").append(tile).append(", ...);\n");
        }
        builder.append("\nSpecial Tiles:\n");
        for (Object tile : specialTiles) {
            c = NICE_CHARS.charAt(i++);
            if (i > NICE_CHARS.length()) {
                return "Too complicated for nice chars";
            }
            map.put(tile, Character.valueOf(c));
            builder.append(c).append(" -> ofSpecialTileAdder(").append((String)tile).append(", ...); // You will probably want to change it to something else\n");
        }
        builder.append("\nOffsets:\n").append(basePositionA).append(' ').append(basePositionB).append(' ').append(basePositionC).append('\n');
        if (transpose) {
            builder.append("\nTransposed Scan:\n").append("new String[][]{\n").append("    {\"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                BlockEntity tileEntity = w.getBlockEntity(new BlockPos(x, y, z));
                if (tileEntity == null) {
                    Block block = w.getBlockState(new BlockPos(x, y, z)).getBlock();
                    if (block != null && block != Blocks.AIR) {
                        builder.append(map.get(net.minecraft.core.Registry.BLOCK.getKey((Object)block).toString()));
                    } else {
                        builder.append(' ');
                    }
                } else {
                    String classification = (String)tileEntityClassifier.apply(tileEntity);
                    if (classification == null) {
                        classification = tileEntity.getClass().getCanonicalName();
                    }
                    builder.append(map.get(classification));
                }
            }, () -> builder.append("\",\""), () -> {
                builder.setLength(builder.length() - 2);
                builder.append("},\n    {\"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("\n}\n\n");
        } else {
            builder.append("\nNormal Scan:\n").append("new String[][]{{\n").append("    \"");
            StructureUtility.iterate(world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, sizeA, sizeB, sizeC, (w, x, y, z) -> {
                BlockEntity tileEntity = w.getBlockEntity(new BlockPos(x, y, z));
                if (tileEntity == null) {
                    Block block = w.getBlockState(new BlockPos(x, y, z)).getBlock();
                    if (block != null && block != Blocks.AIR) {
                        builder.append(map.get(net.minecraft.core.Registry.BLOCK.getKey((Object)block).toString()));
                    } else {
                        builder.append(' ');
                    }
                } else {
                    String classification = (String)tileEntityClassifier.apply(tileEntity);
                    if (classification == null) {
                        classification = tileEntity.getClass().getCanonicalName();
                    }
                    builder.append(map.get(classification));
                }
            }, () -> builder.append("\",\n").append("    \""), () -> {
                builder.setLength(builder.length() - 7);
                builder.append("\n").append("},{\n").append("    \"");
            });
            builder.setLength(builder.length() - 8);
            builder.append("}\n\n");
        }
        return builder.toString().replaceAll("\"\"", "E");
    }

    static <T> boolean iterateV2(IStructureElement<T>[] elements, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, IStructureWalker<T> predicate, String iterateType) {
        basePositionA = -basePositionA;
        basePositionB = -basePositionB;
        basePositionC = -basePositionC;
        int[] abc = new int[]{basePositionA, basePositionB, basePositionC};
        int[] xyz = new int[3];
        boolean failed = false;
        for (IStructureElement<T> element : elements) {
            if (element.isNavigating()) {
                abc[0] = (element.resetA() ? basePositionA : abc[0]) + element.getStepA();
                abc[1] = (element.resetB() ? basePositionB : abc[1]) + element.getStepB();
                abc[2] = (element.resetC() ? basePositionC : abc[2]) + element.getStepC();
                continue;
            }
            extendedFacing.getLevelOffset(abc, xyz);
            xyz[0] = xyz[0] + basePositionX;
            xyz[1] = xyz[1] + basePositionY;
            xyz[2] = xyz[2] + basePositionZ;
            if (StructureLibAPI.isDebugEnabled()) {
                StructureLib.LOGGER.info("Multi [{}, {}, {}] {} step @ {} {}", (Object)basePositionX, (Object)basePositionY, (Object)basePositionZ, (Object)iterateType, (Object)Arrays.toString(xyz), (Object)Arrays.toString(abc));
            }
            if (world.isLoaded(new BlockPos(xyz[0], xyz[1], xyz[2]))) {
                if (StructureLibAPI.isInstrumentEnabled()) {
                    StructureEvent.StructureElementVisitedEvent.fireEvent(world, xyz[0], xyz[1], xyz[2], abc[0] - basePositionA, abc[1] - basePositionB, abc[2] - basePositionC, element);
                }
                if (!predicate.visit(element, world, xyz[0], xyz[1], xyz[2], abc[0], abc[1], abc[2])) {
                    if (StructureLibAPI.isDebugEnabled()) {
                        StructureLib.LOGGER.info("Multi [{}, {}, {}] {} stop @ {} {}", (Object)basePositionX, (Object)basePositionY, (Object)basePositionZ, (Object)iterateType, (Object)Arrays.toString(xyz), (Object)Arrays.toString(abc));
                    }
                    failed = true;
                }
            } else {
                if (StructureLibAPI.isDebugEnabled()) {
                    StructureLib.LOGGER.info("Multi [{}, {}, {}] {} !blockExists @ {} {}", (Object)basePositionX, (Object)basePositionY, (Object)basePositionZ, (Object)iterateType, (Object)Arrays.toString(xyz), (Object)Arrays.toString(abc));
                }
                if (!predicate.blockNotLoaded(element, world, xyz[0], xyz[1], xyz[2], abc[0], abc[1], abc[2])) {
                    failed = true;
                }
            }
            abc[0] = abc[0] + 1;
        }
        return !failed;
    }

    public static void iterate(Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        abc[2] = -basePositionC;
        while (abc[2] < sizeC) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[0] = -basePositionA;
                while (abc[0] < sizeA) {
                    extendedFacing.getLevelOffset(abc, xyz);
                    iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                    abc[0] = abc[0] + 1;
                }
                abc[1] = abc[1] + 1;
            }
            abc[2] = abc[2] + 1;
        }
    }

    public static void iterate(Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean transpose, int sizeA, int sizeB, int sizeC, IBlockPosConsumer iBlockPosConsumer, Runnable nextB, Runnable nextC) {
        sizeA -= basePositionA;
        sizeB -= basePositionB;
        sizeC -= basePositionC;
        int[] abc = new int[3];
        int[] xyz = new int[3];
        if (transpose) {
            abc[1] = -basePositionB;
            while (abc[1] < sizeB) {
                abc[2] = -basePositionC;
                while (abc[2] < sizeC) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getLevelOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[2] = abc[2] + 1;
                }
                nextC.run();
                abc[1] = abc[1] + 1;
            }
        } else {
            abc[2] = -basePositionC;
            while (abc[2] < sizeC) {
                abc[1] = -basePositionB;
                while (abc[1] < sizeB) {
                    abc[0] = -basePositionA;
                    while (abc[0] < sizeA) {
                        extendedFacing.getLevelOffset(abc, xyz);
                        iBlockPosConsumer.consume(world, xyz[0] + basePositionX, xyz[1] + basePositionY, xyz[2] + basePositionZ);
                        abc[0] = abc[0] + 1;
                    }
                    nextB.run();
                    abc[1] = abc[1] + 1;
                }
                nextC.run();
                abc[2] = abc[2] + 1;
            }
        }
    }

    public static String[][] transpose(String[][] structurePiece) {
        String[][] shape = new String[structurePiece[0].length][structurePiece.length];
        for (int i = 0; i < structurePiece.length; ++i) {
            for (int j = 0; j < structurePiece[i].length; ++j) {
                shape[j][i] = structurePiece[i][j];
            }
        }
        return shape;
    }
}

