/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureWalker;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.structure.SurvivalBuildStructureWalker;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IStructureDefinition<T> {
    public IStructureElement<T>[] getStructureFor(String var1);

    public boolean isContainedInStructure(String var1, int var2, int var3, int var4);

    default public boolean check(T object, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean forceCheckAllBlocks) {
        return IStructureDefinition.iterate(object, null, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, forceCheckAllBlocks);
    }

    default public boolean hints(T object, ItemStack trigger, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, null);
    }

    default public boolean build(T object, ItemStack trigger, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, null);
    }

    default public boolean buildOrHints(T object, ItemStack trigger, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, hintsOnly, null);
    }

    @Deprecated
    default public int survivalBuild(T object, ItemStack trigger, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int elementBudget, IItemSource source, ServerPlayer actor, boolean check) {
        Player realActor;
        if (actor == null) {
            realActor = ISurvivalConstructable.__get_player();
            if (realActor == null) {
                throw new IllegalArgumentException();
            }
        } else {
            realActor = actor;
        }
        return this.survivalBuild(object, trigger, piece, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, elementBudget, ISurvivalBuildEnvironment.create(source, realActor), check);
    }

    default public int survivalBuild(T object, ItemStack trigger, String piece, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        SurvivalBuildStructureWalker<T> walker = new SurvivalBuildStructureWalker<T>(object, trigger, elementBudget, env, this, piece, extendedFacing, new int[]{basePositionA, basePositionB, basePositionC}, check);
        StructureUtility.iterateV2(this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, walker, "survivalBuild");
        return walker.getBuilt();
    }

    public static <T> boolean iterate(T object, ItemStack trigger, IStructureElement<T>[] elements, Level world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly, Boolean checkBlocksIfNotNullForceCheckAllIfTrue) {
        if (!world.isClientSide && hintsOnly) {
            return false;
        }
        if (checkBlocksIfNotNullForceCheckAllIfTrue != null) {
            Object2ObjectOpenHashMap structurePositions = new Object2ObjectOpenHashMap();
            Function<IStructureWalker, IStructureWalker> walkerFunction = pred -> checkBlocksIfNotNullForceCheckAllIfTrue != false ? pred : IStructureWalker.skipBlockUnloaded(pred);
            String typeAddition = checkBlocksIfNotNullForceCheckAllIfTrue != false ? "" : " force";
            boolean success = StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, walkerFunction.apply((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7) -> IStructureDefinition.lambda$iterate$1(object, (Map)structurePositions, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7)), "check" + typeAddition);
            if (success) {
                structurePositions.forEach((b, e) -> e.onStructureSuccess(object, world, b.getX(), b.getY(), b.getZ()));
                if (StructureLibAPI.isDebugEnabled()) {
                    StructureLib.LOGGER.info("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] pass");
                }
            } else {
                structurePositions.forEach((b, e) -> e.onStructureFail(object, world, b.getX(), b.getY(), b.getZ()));
            }
            return success;
        }
        if (hintsOnly) {
            StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, IStructureWalker.ignoreBlockUnloaded((e, w, x, y, z, a, b, c) -> {
                e.spawnHint(object, world, x, y, z, trigger);
                return true;
            }), "spawnHint");
        } else {
            StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, IStructureWalker.ignoreBlockUnloaded((e, w, x, y, z, a, b, c) -> {
                e.placeBlock(object, world, x, y, z, trigger);
                return true;
            }), "placeBlock");
        }
        return true;
    }

    public static <T> StructureDefinition.Builder<T> builder() {
        return StructureDefinition.builder();
    }

    private static /* synthetic */ boolean lambda$iterate$1(Object object, Map structurePositions, IStructureElement e, Level w, int x, int y, int z, int a, int b, int c) {
        boolean check = e.check(object, w, x, y, z);
        structurePositions.put(new BlockPos(x, y, z), e);
        return check;
    }
}

