/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.net;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.util.PlatformUtils;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AlignmentMessage<T extends AlignmentMessage<T>>
implements Packet<T> {
    BlockPos pos;
    String dimensionID;
    int mAlign;

    public AlignmentMessage(BlockPos pos, String dimension, int align) {
        this.pos = pos;
        this.dimensionID = dimension;
        this.mAlign = align;
    }

    private AlignmentMessage(IAlignmentProvider provider) {
        if (!(provider instanceof BlockEntity)) {
            throw new IllegalArgumentException("Provider must be a BlockEntity");
        }
        BlockEntity base = (BlockEntity)provider;
        IAlignment alignment = provider.getAlignment();
        if (alignment == null) {
            throw new IllegalArgumentException("Passed in provider does not provide an alignment!");
        }
        this.pos = base.getBlockPos();
        if (base.getLevel() == null) {
            throw new IllegalStateException("Somehow world is null!");
        }
        this.dimensionID = base.getLevel().dimension().location().toString();
        this.mAlign = alignment.getExtendedFacing().getIndex();
    }

    private AlignmentMessage(Level world, BlockPos pos, IAlignment front) {
        this.pos = pos;
        this.dimensionID = world.dimension().location().toString();
        this.mAlign = front.getExtendedFacing().getIndex();
    }

    static class ServerHandler
    implements PacketHandler<AlignmentQuery> {
        ServerHandler() {
        }

        public void encode(AlignmentQuery msg, FriendlyByteBuf buf) {
            buf.writeBlockPos(msg.pos);
            buf.writeUtf(msg.dimensionID);
            buf.writeInt(msg.mAlign);
        }

        public AlignmentQuery decode(FriendlyByteBuf buf) {
            return new AlignmentQuery(buf.readBlockPos(), buf.readUtf(), buf.readInt());
        }

        public PacketContext handle(AlignmentQuery msg) {
            return (player, level) -> {
                BlockEntity te;
                ServerLevel world = PlatformUtils.INSTANCE.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)new ResourceLocation(msg.dimensionID)));
                if (world != null && (te = world.getBlockEntity(msg.pos)) instanceof IAlignmentProvider) {
                    IAlignmentProvider provider = (IAlignmentProvider)te;
                    IAlignment alignment = provider.getAlignment();
                    if (alignment == null) {
                        return;
                    }
                    StructureLib.CHANNEL.sendToPlayer((Packet)new AlignmentData((Level)world, msg.pos, alignment), player);
                }
            };
        }
    }

    static class ClientHandler
    implements PacketHandler<AlignmentData> {
        ClientHandler() {
        }

        public void encode(AlignmentData msg, FriendlyByteBuf buf) {
            buf.writeBlockPos(msg.pos);
            buf.writeUtf(msg.dimensionID);
            buf.writeInt(msg.mAlign);
        }

        public AlignmentData decode(FriendlyByteBuf buf) {
            return new AlignmentData(buf.readBlockPos(), buf.readUtf(), buf.readInt());
        }

        public PacketContext handle(AlignmentData msg) {
            return (player, level) -> {
                IAlignmentProvider provider;
                IAlignment alignment;
                BlockEntity te;
                if (StructureLib.getCurrentPlayer().level.dimension().location().toString().equals(msg.dimensionID) && (te = StructureLib.getCurrentPlayer().level.getBlockEntity(msg.pos)) instanceof IAlignmentProvider && (alignment = (provider = (IAlignmentProvider)te).getAlignment()) != null) {
                    alignment.setExtendedFacing(ExtendedFacing.byIndex(msg.mAlign));
                }
            };
        }
    }

    public static class AlignmentData
    extends AlignmentMessage<AlignmentData> {
        public static final ClientHandler HANDLER = new ClientHandler();

        public AlignmentData(BlockPos pos, String dimension, int align) {
            super(pos, dimension, align);
        }

        public AlignmentData(IAlignmentProvider provider) {
            super(provider);
        }

        public AlignmentData(Level world, BlockPos pos, IAlignment front) {
            super(world, pos, front);
        }

        public ResourceLocation getID() {
            return StructureLib.ALIGNMENT_DATA;
        }

        public PacketHandler<AlignmentData> getHandler() {
            return HANDLER;
        }
    }

    public static class AlignmentQuery
    extends AlignmentMessage<AlignmentQuery> {
        public static final ServerHandler HANDLER = new ServerHandler();

        public AlignmentQuery(BlockPos pos, String dimension, int align) {
            super(pos, dimension, align);
        }

        public AlignmentQuery(IAlignmentProvider provider) {
            super(provider);
        }

        public ResourceLocation getID() {
            return StructureLib.ALIGNMENT_QUERY;
        }

        public PacketHandler<AlignmentQuery> getHandler() {
            return HANDLER;
        }
    }
}

