/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.gui;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.gui.ContainerConfigureChannels;
import com.gtnewhorizon.structurelib.gui.GuiScrollableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class GuiScreenConfigureChannels
extends AbstractContainerScreen<ContainerConfigureChannels>
implements GuiScrollableList.IGuiScreen {
    private static final int KEY_MAX_WIDTH = 50;
    private final ItemStack trigger;
    private final InteractionHand hand;
    private EditBox key;
    private EditBox value;
    protected int guiTop;
    protected int guiLeft;
    private List<Button> buttonList = new ArrayList<Button>();

    public GuiScreenConfigureChannels(ContainerConfigureChannels container, Inventory invPlayer, Component title) {
        super((AbstractContainerMenu)container, invPlayer, title);
        this.trigger = invPlayer.player.getItemInHand(container.hand);
        this.hand = container.hand;
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.getXSize()) / 2;
        this.guiTop = (this.height - this.getYSize()) / 2;
        this.key = new EditBox(this.font, this.guiLeft + 45, this.guiTop + 119, 118, 12, (Component)new TextComponent("")){

            public void insertText(String textToWrite) {
                super.insertText(textToWrite.toLowerCase(Locale.ROOT));
                GuiScreenConfigureChannels.this.updateButtons();
            }

            public void setValue(String text) {
                super.setValue(text);
                GuiScreenConfigureChannels.this.updateButtons();
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                boolean flag;
                boolean bl = flag = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
                if (flag && button == 1) {
                    GuiScreenConfigureChannels.this.key.setValue("");
                    GuiScreenConfigureChannels.this.value.setValue("");
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }
        };
        this.value = new EditBox(this.font, this.guiLeft + 45, this.guiTop + 139, 118, 12, (Component)new TextComponent("")){

            public void insertText(String text) {
                if (text != null && text.codePoints().allMatch(Character::isDigit)) {
                    super.insertText(text);
                    GuiScreenConfigureChannels.this.updateButtons();
                }
            }

            public void setFocused(boolean focused) {
                if (!focused && this.isFocused() && !StringUtils.isBlank((CharSequence)this.getValue())) {
                    int result;
                    try {
                        result = Math.max(Integer.parseInt(this.getValue()), 1);
                    }
                    catch (NumberFormatException e) {
                        result = 1;
                    }
                    this.setValue(String.valueOf(result));
                }
                super.setFocused(focused);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                boolean flag;
                boolean bl = flag = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
                if (flag && button == 1) {
                    this.setValue("");
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }

            public void setValue(String text) {
                super.setValue(text);
                GuiScreenConfigureChannels.this.updateButtons();
            }
        };
        this.key.setMaxLength(32500);
        this.value.setMaxLength(32500);
        this.addRenderableOnly((Widget)this.key);
        this.addRenderableOnly((Widget)this.value);
        this.addButton(new Button(this.guiLeft + 12, this.guiTop + 157, 47, 20, (Component)new TranslatableComponent("item.structurelib.constructableTrigger.gui.add"), b -> {
            int value = this.getValue();
            if (value <= 0) {
                return;
            }
            ChannelDataAccessor.setChannelData(this.trigger, this.key.getValue(), value);
        }));
        this.addButton(new Button(this.guiLeft + 65, this.guiTop + 157, 47, 20, (Component)new TranslatableComponent("item.structurelib.constructableTrigger.gui.unset"), b -> ChannelDataAccessor.unsetChannelData(this.trigger, this.key.getValue())));
        this.addButton(new Button(this.guiLeft + 118, this.guiTop + 157, 47, 20, (Component)new TranslatableComponent("item.structurelib.constructableTrigger.gui.wipe"), b -> ChannelDataAccessor.wipeChannelData(this.trigger)));
        this.updateButtons();
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getXSize() {
        return 176;
    }

    @Override
    public int getYSize() {
        return 188;
    }

    @Override
    public void addButton(Button button) {
        this.getButtonList().add(button);
        this.addWidget((GuiEventListener)button);
    }

    @Override
    public void removeButton(Button button) {
        this.getButtonList().remove(button);
        this.removeWidget((GuiEventListener)button);
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    @Override
    public void doActionPerformed(Button but) {
    }

    private List<Button> getButtonList() {
        return this.buttonList;
    }

    private void updateButtons() {
        String keyText = this.key.getValue();
        boolean existing = !StringUtils.isEmpty((CharSequence)keyText) && ChannelDataAccessor.hasSubChannel(this.trigger, keyText);
        String translation = existing ? "item.structurelib.constructableTrigger.gui.set" : "item.structurelib.constructableTrigger.gui.add";
        this.getButtonList().get(0).setMessage((Component)new TranslatableComponent(translation));
        this.getButtonList().get((int)0).active = !StringUtils.isBlank((CharSequence)this.value.getValue());
        this.getButtonList().get((int)1).active = existing && !StringUtils.isBlank((CharSequence)this.value.getValue());
    }

    private int getValue() {
        try {
            return Integer.parseInt(this.value.getValue());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void onClose() {
        super.onClose();
        StructureLib.instance().proxy().uploadChannels(this.trigger, this.hand);
    }

    protected void renderBg(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.drawTexture(poseStack, new ResourceLocation("structurelib", "textures/gui/channels.png"), this.guiLeft, this.guiTop, 0, 0, 176, 188);
    }

    protected void renderLabels(PoseStack poseStack, int mouseX, int mouseY) {
        super.renderLabels(poseStack, mouseX, mouseY);
        this.font.draw(poseStack, (Component)new TranslatableComponent("item.structurelib.constructableTrigger.gui.key"), 12.0f, 122.0f, 0x404040);
        this.font.draw(poseStack, (Component)new TranslatableComponent("item.structurelib.constructableTrigger.gui.value"), 12.0f, 142.0f, 0x404040);
    }

    @Override
    public void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)loc);
        GuiComponent.blit((PoseStack)stack, (int)left, (int)top, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)this.getXSize(), (int)this.getYSize());
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Screen getGui() {
        return this;
    }
}

