/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.util.MiscUtils;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ChannelDataAccessor {
    private static final String SECONDARY_HINT_TAG = "channels";

    private ChannelDataAccessor() {
    }

    public static ItemStack withChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.hasTag() && masterStack.getTag().contains(SECONDARY_HINT_TAG, 10) && masterStack.getTag().getCompound(SECONDARY_HINT_TAG).contains(channel, 3))) {
            return masterStack;
        }
        ItemStack ret = new ItemStack((ItemLike)masterStack.getItem(), masterStack.getTag().getCompound(SECONDARY_HINT_TAG).getInt(channel));
        ret.setTag(masterStack.getTag());
        return ret;
    }

    public static boolean hasSubChannel(ItemStack masterStack) {
        if (masterStack.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return masterStack.hasTag() && masterStack.getTag().contains(SECONDARY_HINT_TAG, 10);
    }

    public static boolean hasSubChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        return !channel.isEmpty() && masterStack.hasTag() && masterStack.getTag().contains(SECONDARY_HINT_TAG, 10) && masterStack.getTag().getCompound(SECONDARY_HINT_TAG).contains(channel, 3);
    }

    public static int getChannelData(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.hasTag() && masterStack.getTag().contains(SECONDARY_HINT_TAG, 10) && masterStack.getTag().getCompound(SECONDARY_HINT_TAG).contains(channel, 3))) {
            return masterStack.getCount();
        }
        return masterStack.getTag().getCompound(SECONDARY_HINT_TAG).getInt(channel);
    }

    public static void setChannelData(ItemStack masterStack, String channel, int data) {
        CompoundTag main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (data <= 0) {
            throw new IllegalArgumentException();
        }
        if (masterStack.getTag() == null) {
            masterStack.setTag(new CompoundTag());
        }
        if (!(main = masterStack.getTag()).contains(SECONDARY_HINT_TAG, 10)) {
            main.put(SECONDARY_HINT_TAG, (Tag)new CompoundTag());
        }
        main.getCompound(SECONDARY_HINT_TAG).putInt(channel, data);
    }

    public static void unsetChannelData(ItemStack masterStack, String channel) {
        CompoundTag main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (masterStack.getTag() == null) {
            masterStack.setTag(new CompoundTag());
        }
        if (!(main = masterStack.getTag()).contains(SECONDARY_HINT_TAG, 10)) {
            main.put(SECONDARY_HINT_TAG, (Tag)new CompoundTag());
        }
        CompoundTag tag = main.getCompound(SECONDARY_HINT_TAG);
        tag.remove(channel);
        if (tag.isEmpty()) {
            main.remove(SECONDARY_HINT_TAG);
        }
        if (main.isEmpty()) {
            masterStack.setTag(null);
        }
    }

    public static void wipeChannelData(ItemStack masterStack) {
        if (masterStack.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (masterStack.getTag() != null) {
            masterStack.getTag().remove(SECONDARY_HINT_TAG);
        }
    }

    public static Stream<Map.Entry<String, Integer>> iterateChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return Stream.empty();
        }
        CompoundTag tag = masterStack.getTag().getCompound(SECONDARY_HINT_TAG);
        return MiscUtils.getTagKeys(tag).stream().map(s -> new ImmutablePair(s, (Object)tag.getInt(s)));
    }

    public static int countChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return 0;
        }
        CompoundTag tag = masterStack.getTag().getCompound(SECONDARY_HINT_TAG);
        return tag.getAllKeys().size();
    }
}

