/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class IntegerAxisSwap {
    private final Vec3i forFirstAxis;
    private final Vec3i forSecondAxis;
    private final Vec3i forThirdAxis;

    public IntegerAxisSwap(Direction forFirstAxis, Direction forSecondAxis, Direction forThirdAxis) {
        this.forFirstAxis = forFirstAxis.getNormal();
        this.forSecondAxis = forSecondAxis.getNormal();
        this.forThirdAxis = forThirdAxis.getNormal();
        if (Math.abs(this.forFirstAxis.getX()) + Math.abs(this.forSecondAxis.getX()) + Math.abs(this.forThirdAxis.getX()) != 1 || Math.abs(this.forFirstAxis.getY()) + Math.abs(this.forSecondAxis.getY()) + Math.abs(this.forThirdAxis.getY()) != 1 || Math.abs(this.forFirstAxis.getZ()) + Math.abs(this.forSecondAxis.getZ()) + Math.abs(this.forThirdAxis.getZ()) != 1) {
            throw new IllegalArgumentException("Axis are overlapping/missing! " + forFirstAxis.name() + " " + forSecondAxis.name() + " " + forThirdAxis.name());
        }
    }

    public Vec3i translate(Vec3i point) {
        return new Vec3i(this.forFirstAxis.getX() * point.getX() + this.forFirstAxis.getY() * point.getY() + this.forFirstAxis.getZ() * point.getZ(), this.forSecondAxis.getX() * point.getX() + this.forSecondAxis.getY() * point.getY() + this.forSecondAxis.getZ() * point.getZ(), this.forThirdAxis.getX() * point.getX() + this.forThirdAxis.getY() * point.getY() + this.forThirdAxis.getZ() * point.getZ());
    }

    public Vec3i inverseTranslate(Vec3i point) {
        return new Vec3i(this.forFirstAxis.getX() * point.getX() + this.forSecondAxis.getX() * point.getY() + this.forThirdAxis.getX() * point.getZ(), this.forFirstAxis.getY() * point.getX() + this.forSecondAxis.getY() * point.getY() + this.forThirdAxis.getY() * point.getZ(), this.forFirstAxis.getZ() * point.getX() + this.forSecondAxis.getZ() * point.getY() + this.forThirdAxis.getZ() * point.getZ());
    }

    public Vec3 translate(Vec3 point) {
        return new Vec3((double)this.forFirstAxis.getX() * point.x + (double)this.forFirstAxis.getY() * point.y + (double)this.forFirstAxis.getZ() * point.z, (double)this.forSecondAxis.getX() * point.x + (double)this.forSecondAxis.getY() * point.y + (double)this.forSecondAxis.getZ() * point.z, (double)this.forThirdAxis.getX() * point.x + (double)this.forThirdAxis.getY() * point.y + (double)this.forThirdAxis.getZ() * point.z);
    }

    public Vec3 inverseTranslate(Vec3 point) {
        return new Vec3((double)this.forFirstAxis.getX() * point.x + (double)this.forSecondAxis.getX() * point.y + (double)this.forThirdAxis.getX() * point.z, (double)this.forFirstAxis.getY() * point.x + (double)this.forSecondAxis.getY() * point.y + (double)this.forThirdAxis.getY() * point.z, (double)this.forFirstAxis.getZ() * point.x + (double)this.forSecondAxis.getZ() * point.y + (double)this.forThirdAxis.getZ() * point.z);
    }

    public void translate(int[] point, int[] out) {
        out[0] = this.forFirstAxis.getX() * point[0] + this.forFirstAxis.getY() * point[1] + this.forFirstAxis.getZ() * point[2];
        out[1] = this.forSecondAxis.getX() * point[0] + this.forSecondAxis.getY() * point[1] + this.forSecondAxis.getZ() * point[2];
        out[2] = this.forThirdAxis.getX() * point[0] + this.forThirdAxis.getY() * point[1] + this.forThirdAxis.getZ() * point[2];
    }

    public void inverseTranslate(int[] point, int[] out) {
        out[0] = this.forFirstAxis.getX() * point[0] + this.forSecondAxis.getX() * point[1] + this.forThirdAxis.getX() * point[2];
        out[1] = this.forFirstAxis.getY() * point[0] + this.forSecondAxis.getY() * point[1] + this.forThirdAxis.getY() * point[2];
        out[2] = this.forFirstAxis.getZ() * point[0] + this.forSecondAxis.getZ() * point[1] + this.forThirdAxis.getZ() * point[2];
    }

    public void translate(double[] point, double[] out) {
        out[0] = (double)this.forFirstAxis.getX() * point[0] + (double)this.forFirstAxis.getY() * point[1] + (double)this.forFirstAxis.getZ() * point[2];
        out[1] = (double)this.forSecondAxis.getX() * point[0] + (double)this.forSecondAxis.getY() * point[1] + (double)this.forSecondAxis.getZ() * point[2];
        out[2] = (double)this.forThirdAxis.getX() * point[0] + (double)this.forThirdAxis.getY() * point[1] + (double)this.forThirdAxis.getZ() * point[2];
    }

    public void inverseTranslate(double[] point, double[] out) {
        out[0] = (double)this.forFirstAxis.getX() * point[0] + (double)this.forSecondAxis.getX() * point[1] + (double)this.forThirdAxis.getX() * point[2];
        out[1] = (double)this.forFirstAxis.getY() * point[0] + (double)this.forSecondAxis.getY() * point[1] + (double)this.forThirdAxis.getY() * point[2];
        out[2] = (double)this.forFirstAxis.getZ() * point[0] + (double)this.forSecondAxis.getZ() * point[1] + (double)this.forThirdAxis.getZ() * point[2];
    }
}

