/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.net.AlignmentMessage;
import com.gtnewhorizon.structurelib.util.PlatformUtils;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StructureLibAPI {
    public static final String MOD_ID = "structurelib";
    static final ThreadLocal<Object> instrument = new ThreadLocal();

    public static void enableInstrument(Object identifier) {
        if (StructureLibAPI.isInstrumentEnabled()) {
            throw new IllegalStateException();
        }
        instrument.set(instrument);
    }

    public static void disableInstrument() {
        if (!StructureLibAPI.isInstrumentEnabled()) {
            throw new IllegalStateException();
        }
        instrument.set(null);
    }

    public static boolean isInstrumentEnabled() {
        return instrument.get() != null;
    }

    public static void startHinting(Level w) {
        StructureLib.proxy.startHinting(w);
    }

    public static void endHinting(Level w) {
        StructureLib.proxy.endHinting(w);
    }

    public static void hintParticleTinted(Level w, int x, int y, int z, TextureAtlasSprite[] icons, short[] RGBa) {
        StructureLib.proxy.hintParticleTinted(w, x, y, z, icons, RGBa);
    }

    public static void hintParticleTinted(Level w, int x, int y, int z, Block block, short[] RGBa) {
        StructureLib.proxy.hintParticleTinted(w, x, y, z, block, RGBa);
    }

    public static void hintParticle(Level w, int x, int y, int z, TextureAtlasSprite[] icons) {
        StructureLib.proxy.hintParticle(w, x, y, z, icons);
    }

    public static void hintParticle(Level w, int x, int y, int z, Block block) {
        StructureLib.proxy.hintParticle(w, x, y, z, block);
    }

    public static boolean markHintParticleError(Player player, Level w, int x, int y, int z) {
        return StructureLib.proxy.markHintParticleError(player, w, x, y, z);
    }

    public static boolean updateHintParticleTint(Player player, Level w, int x, int y, int z, short[] RGBa) {
        return StructureLib.proxy.updateHintParticleTint(player, w, x, y, z, RGBa);
    }

    public static void queryAlignment(IAlignmentProvider provider) {
        StructureLib.CHANNEL.sendToServer((Packet)new AlignmentMessage.AlignmentQuery(provider));
    }

    public static void sendAlignment(IAlignmentProvider provider) {
        StructureLib.CHANNEL.sendToAllPlayers((Packet)new AlignmentMessage.AlignmentData(provider), PlatformUtils.INSTANCE.getCurrentServer());
    }

    public static void sendAlignment(IAlignmentProvider provider, ServerPlayer player) {
        StructureLib.CHANNEL.sendToPlayer((Packet)new AlignmentMessage.AlignmentData(provider), (Player)player);
    }

    public static void sendAlignment(IAlignmentProvider provider, BlockPos target, double range, ServerLevel level) {
        StructureLib.CHANNEL.sendToPlayersInRange((Packet)new AlignmentMessage.AlignmentData(provider), (Level)level, target, range);
    }

    public static void sendAlignment(IAlignmentProvider provider, Level dimension) {
        StructureLib.CHANNEL.sendToPlayersInLevel((Packet)new AlignmentMessage.AlignmentData(provider), dimension);
    }

    public static boolean isDebugEnabled() {
        return StructureLib.DEBUG_MODE;
    }

    public static void setDebugEnabled(boolean enabled) {
        StructureLib.DEBUG_MODE = enabled;
    }

    @Deprecated
    public static boolean isBlockTriviallyReplaceable(Level w, int x, int y, int z, ServerPlayer actor) {
        return StructureLibAPI.isBlockTriviallyReplaceable(w, x, y, z, (Player)actor);
    }

    public static boolean isBlockTriviallyReplaceable(Level w, int x, int y, int z, Player actor) {
        BlockState block = w.getBlockState(new BlockPos(x, y, z));
        return block.isAir() || block.getMaterial().isReplaceable();
    }

    public static void addThrottledChat(Object throttleKey, Player player, Component text, short intervalRequired) {
        StructureLibAPI.addThrottledChat(throttleKey, player, text, intervalRequired, false);
    }

    public static void addThrottledChat(Object throttleKey, Player player, Component text, short intervalRequired, boolean forceUpdateLastSend) {
        StructureLib.proxy.addThrottledChat(throttleKey, player, text, intervalRequired, forceUpdateLastSend);
    }
}

