/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import net.minecraft.world.level.Level;

public abstract class StructureEvent {
    private final Object identifier = StructureLibAPI.instrument.get();

    StructureEvent() {
    }

    public Object getInstrumentIdentifier() {
        return this.identifier;
    }

    public static final class StructureElementVisitedEvent
    extends StructureEvent {
        private final Level world;
        private final int x;
        private final int y;
        private final int z;
        private final int a;
        private final int b;
        private final int c;
        private final IStructureElement<?> element;

        public static void fireEvent(Level world, int x, int y, int z, int a, int b, int c, IStructureElement<?> element) {
            if (StructureLibAPI.isInstrumentEnabled()) {
                // empty if block
            }
        }

        StructureElementVisitedEvent(Level world, int x, int y, int z, int a, int b, int c, IStructureElement<?> element) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.a = a;
            this.b = b;
            this.c = c;
            this.element = element;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public IStructureElement<?> getElement() {
            return this.element;
        }

        public String toString() {
            return "StructureElementVisitedEvent{a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", element=" + this.element + ", world=" + this.getLevel() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + "}";
        }

        public Level getLevel() {
            return this.world;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }
    }
}

