/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import com.gtnewhorizon.structurelib.util.InventoryIterable;
import com.gtnewhorizon.structurelib.util.ItemStackMap;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizon.structurelib.util.SortedRegistry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtility {
    private static final SortedRegistry<ItemStackExtractor> stackExtractors = new SortedRegistry();
    private static final List<Predicate<? super ServerPlayer>> enableEnder = new CopyOnWriteArrayList<Predicate<? super ServerPlayer>>();
    private static final SortedRegistry<InventoryProvider<?>> inventoryProviders = new SortedRegistry();

    public static void registerEnableEnderCondition(Predicate<? super ServerPlayer> predicate) {
        enableEnder.add(predicate);
    }

    public static void registerStackExtractor(String key, ItemStackExtractor val) {
        if (Arrays.stream(ItemStackExtractor.APIType.values()).noneMatch(val::isAPIImplemented)) {
            throw new IllegalArgumentException("Must implement at least one API");
        }
        stackExtractors.register(key, val);
    }

    public static <Inv extends Container> void registerStackExtractor(String key, Function<ItemStack, ? extends Inv> extractor) {
        InventoryUtility.registerStackExtractor(key, InventoryUtility.newItemStackProvider(extractor));
    }

    public static void registerInventoryProvider(String key, InventoryProvider<?> val) {
        inventoryProviders.register(key, val);
    }

    public static <Inv extends Container> void registerInventoryProvider(String key, Function<ServerPlayer, ? extends Inv> extractor) {
        InventoryUtility.registerInventoryProvider(key, InventoryUtility.newInventoryProvider(extractor));
    }

    public static Iterator<? extends ItemStackExtractor> getStackExtractors() {
        return stackExtractors.iterator();
    }

    public static <Inv extends Container> InventoryProvider<InventoryIterable<Inv>> newInventoryProvider(final Function<ServerPlayer, ? extends Inv> extractor) {
        return new InventoryProvider<InventoryIterable<Inv>>(){

            @Override
            public InventoryIterable<Inv> getInventory(ServerPlayer player) {
                Container inv = (Container)extractor.apply(player);
                return inv != null ? new InventoryIterable<Container>(inv) : null;
            }

            @Override
            public void markDirty(InventoryIterable<Inv> inv) {
            }
        };
    }

    public static ItemStackExtractor newItemStackProvider(final Function<ItemStack, ? extends Container> extractor) {
        return new ItemStackExtractor(){

            @Override
            public boolean isAPIImplemented(ItemStackExtractor.APIType type) {
                return type == ItemStackExtractor.APIType.MAIN;
            }

            @Override
            public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounter store, ItemStack stack, ItemStack filter, ServerPlayer player) {
                Container inv = (Container)extractor.apply(stack);
                if (inv == null) {
                    return 0;
                }
                int found = InventoryUtility.takeFromInventory(new InventoryIterable<Container>(inv), predicate, simulate, count, store, filter, player, false);
                if (found > 0) {
                    // empty if block
                }
                return found;
            }
        };
    }

    public static Map<ItemStack, Integer> takeFromInventory(ServerPlayer player, Predicate<ItemStack> predicate, boolean simulate, int count) {
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        int sum = 0;
        for (InventoryProvider<?> provider : inventoryProviders) {
            if ((sum += InventoryUtility.takeFromPlayer(player, predicate, simulate, count - sum, store, provider, null)) < count) continue;
            return store.getStore();
        }
        return store.getStore();
    }

    public static int takeFromInventory(ServerPlayer player, ItemStack filter, boolean simulate) {
        int sum = 0;
        int count = filter.m_41613_();
        ItemStackPredicate predicate = ItemStackPredicate.from(filter, ItemStackPredicate.NBTMode.EXACT);
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        for (InventoryProvider<?> provider : inventoryProviders) {
            if ((sum += InventoryUtility.takeFromPlayer(player, predicate, simulate, count - sum, store, provider, filter)) < count) continue;
            return sum;
        }
        return sum;
    }

    private static <R extends Iterable<ItemStack>> int takeFromPlayer(ServerPlayer player, Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounterImpl store, InventoryProvider<R> provider, ItemStack filter) {
        R inv = provider.getInventory(player);
        if (inv == null) {
            return 0;
        }
        int taken = InventoryUtility.takeFromInventory(inv, predicate, simulate, count, store, filter, player, true);
        if (taken > 0) {
            provider.markDirty(inv);
        }
        return taken;
    }

    public static Map<ItemStack, Integer> takeFromInventory(Iterable<ItemStack> inv, Predicate<ItemStack> predicate, boolean simulate, int count, boolean recursive) {
        ItemStackCounterImpl store = new ItemStackCounterImpl();
        InventoryUtility.takeFromInventory(inv, predicate, simulate, count, store, null, null, recursive);
        return store.getStore();
    }

    private static int takeFromInventory(@NotNull Iterable<ItemStack> inv, @NotNull Predicate<ItemStack> predicate, boolean simulate, int count, @NotNull ItemStackCounter store, @Nullable ItemStack filter, @Nullable ServerPlayer player, boolean recursive) {
        int found = 0;
        ItemStack copiedFilter = null;
        if (filter != null) {
            copiedFilter = new ItemStack((ItemLike)filter.m_41720_(), filter.m_41613_());
            copiedFilter.m_41751_(filter.m_41783_());
        }
        Iterator<ItemStack> iterator = inv.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (stack.m_41619_() || stack.m_41613_() <= 0) continue;
            if (predicate.test(stack)) {
                if ((found += stack.m_41613_()) > count) {
                    int surplus = found - count;
                    store.add(stack, stack.m_41613_() - surplus);
                    if (!simulate) {
                        stack.m_41764_(surplus);
                    }
                    return count;
                }
                store.add(stack, stack.m_41613_());
                if (!simulate) {
                    iterator.remove();
                }
                if (found == count) {
                    return count;
                }
            }
            if (!recursive) continue;
            for (ItemStackExtractor f : stackExtractors) {
                if (filter != null && f.isAPIImplemented(ItemStackExtractor.APIType.EXTRACT_ONE_STACK)) {
                    copiedFilter.m_41764_(count - found);
                    found += f.getItem(stack, copiedFilter, simulate, player);
                } else {
                    found += f.takeFromStack(predicate, simulate, count - found, store, stack, filter, player);
                }
                if (found < count) continue;
                return found;
            }
        }
        return found;
    }

    static {
        inventoryProviders.register("5000-main-inventory", new InventoryProvider<InventoryIterable<Inventory>>(){

            @Override
            public InventoryIterable<Inventory> getInventory(ServerPlayer player) {
                return new InventoryIterable<Inventory>(player.m_150109_(), player.m_150109_().m_6643_());
            }

            @Override
            public void markDirty(InventoryIterable<Inventory> inv) {
                inv.getInventory().f_35978_.f_36096_.m_38946_();
            }
        });
        inventoryProviders.register("7000-ender-inventory", new InventoryProvider<InventoryIterable<PlayerEnderChestContainer>>(){

            @Override
            public InventoryIterable<PlayerEnderChestContainer> getInventory(ServerPlayer player) {
                if (enableEnder.stream().anyMatch(p -> p.test(player))) {
                    return new InventoryIterable<PlayerEnderChestContainer>(player.m_36327_());
                }
                return null;
            }

            @Override
            public void markDirty(InventoryIterable<PlayerEnderChestContainer> inv) {
            }
        });
    }

    public static interface ItemStackExtractor {
        public boolean isAPIImplemented(APIType var1);

        public int takeFromStack(Predicate<ItemStack> var1, boolean var2, int var3, ItemStackCounter var4, ItemStack var5, ItemStack var6, ServerPlayer var7);

        default public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, ServerPlayer player) {
            return -1;
        }

        public static ItemStackExtractor createOnlyOptimized(final @NotNull OptimizedExtractor optimizedExtractor) {
            return new ItemStackExtractor(){

                @Override
                public boolean isAPIImplemented(APIType type) {
                    return type == APIType.EXTRACT_ONE_STACK;
                }

                @Override
                public int takeFromStack(Predicate<ItemStack> predicate, boolean simulate, int count, ItemStackCounter store, ItemStack stack, ItemStack filter, ServerPlayer player) {
                    return 0;
                }

                @Override
                public int getItem(ItemStack source, ItemStack toExtract, boolean simulate, ServerPlayer player) {
                    return optimizedExtractor.extract(source, toExtract, simulate, player);
                }
            };
        }

        public static enum APIType {
            MAIN,
            EXTRACT_ONE_STACK;

        }
    }

    public static interface InventoryProvider<R extends Iterable<ItemStack>> {
        public R getInventory(ServerPlayer var1);

        public void markDirty(R var1);
    }

    private static class ItemStackCounterImpl
    implements ItemStackCounter {
        private final Map<ItemStack, Integer> store = new ItemStackMap<Integer>(true);

        private ItemStackCounterImpl() {
        }

        @Override
        public void add(ItemStack stack, int stackSize) {
            if (stack.m_41619_() || stackSize <= 0) {
                throw new IllegalArgumentException();
            }
            this.store.merge(stack, stackSize, Integer::sum);
        }

        public Map<ItemStack, Integer> getStore() {
            return this.store;
        }
    }

    public static interface ItemStackCounter {
        public void add(ItemStack var1, int var2);
    }

    public static interface OptimizedExtractor {
        public int extract(ItemStack var1, ItemStack var2, boolean var3, ServerPlayer var4);
    }
}

