/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementDeferred;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

class LazyStructureElement<T>
implements IStructureElementDeferred<T> {
    private Function<T, IStructureElement<T>> to;
    private IStructureElement<T> elem;

    public LazyStructureElement(Function<T, IStructureElement<T>> to) {
        this.to = to;
    }

    private IStructureElement<T> get(T t) {
        if (this.to != null) {
            this.elem = this.to.apply(t);
            this.to = null;
        }
        return this.elem;
    }

    @Override
    public boolean check(T t, Level world, int x, int y, int z) {
        return this.get(t).check(t, world, x, y, z);
    }

    @Override
    public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
        return this.get(t).placeBlock(t, world, x, y, z, trigger);
    }

    @Override
    public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
        return this.get(t).spawnHint(t, world, x, y, z, trigger);
    }

    @Override
    @Nullable
    public IStructureElement.BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        return this.get(t).getBlocksToPlace(t, world, x, y, z, trigger, env);
    }

    @Override
    public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
        return this.get(t).survivalPlaceBlock(t, world, x, y, z, trigger, s, actor, chatter);
    }

    @Override
    public IStructureElement.PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        return this.get(t).survivalPlaceBlock(t, world, x, y, z, trigger, env);
    }

    @Override
    public void onStructureSuccess(T t, Level world, int x, int y, int z) {
        this.get(t).onStructureSuccess(t, world, x, y, z);
    }

    @Override
    public void onStructureFail(T t, Level world, int x, int y, int z) {
        this.get(t).onStructureFail(t, world, x, y, z);
    }
}

