/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStructureElement<T> {
    public boolean check(T var1, Level var2, int var3, int var4, int var5);

    public boolean spawnHint(T var1, Level var2, int var3, int var4, int var5, ItemStack var6);

    public boolean placeBlock(T var1, Level var2, int var3, int var4, int var5, ItemStack var6);

    default public void onStructureSuccess(T t, Level world, int x, int y, int z) {
    }

    default public void onStructureFail(T t, Level world, int x, int y, int z) {
    }

    @Deprecated
    default public PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, IItemSource s, ServerPlayer actor, Consumer<Component> chatter) {
        if (StructureLib.PANIC_MODE) {
            throw new RuntimeException("Panic Tripwire hit");
        }
        if (StructureLibAPI.isDebugEnabled()) {
            StructureLib.LOGGER.error("Default implementation of survivalPlaceBlock hit! Things aren't going to work well! IStructureElement class: {}", (Object)this.getClass().getName());
        }
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return PlaceResult.REJECT;
        }
        return PlaceResult.SKIP;
    }

    @Nullable
    default public BlocksToPlace getBlocksToPlace(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        return null;
    }

    default public PlaceResult survivalPlaceBlock(T t, Level world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        BlocksToPlace e = this.getBlocksToPlace(t, world, x, y, z, trigger, env);
        IItemSource source = env.getSource();
        Player actor = env.getActor();
        Consumer<Component> chatter = env.getChatter();
        if (e != null) {
            if (this.check(t, world, x, y, z)) {
                return PlaceResult.SKIP;
            }
            if (e.getStacks() == null) {
                ItemStack taken = source.takeOne(e.getPredicate(), true);
                return StructureUtility.survivalPlaceBlock(taken, ItemStackPredicate.NBTMode.EXACT, taken.m_41783_(), true, world, x, y, z, source, actor, chatter);
            }
            for (ItemStack stack : e.getStacks()) {
                if (!source.takeOne(stack, true)) continue;
                return StructureUtility.survivalPlaceBlock(stack, ItemStackPredicate.NBTMode.EXACT, stack.m_41783_(), true, world, x, y, z, source, actor, chatter);
            }
            return PlaceResult.REJECT;
        }
        if (actor instanceof ServerPlayer) {
            return this.survivalPlaceBlock(t, world, x, y, z, trigger, source, (ServerPlayer)actor, chatter);
        }
        if (StructureLib.PANIC_MODE) {
            throw new RuntimeException("Panic Tripwire hit");
        }
        if (StructureLibAPI.isDebugEnabled()) {
            StructureLib.LOGGER.info("Fallback shim code of survivalPlaceBlock hit! Things aren't going to work well! IStructureElement class: {}", (Object)this.getClass().getName());
        }
        return PlaceResult.SKIP;
    }

    default public IStructureElementNoPlacement<T> noPlacement() {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, Level world, int x, int y, int z) {
                return IStructureElement.this.check(t, world, x, y, z);
            }

            @Override
            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return IStructureElement.this.spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    default public int getStepA() {
        return 1;
    }

    default public int getStepB() {
        return 0;
    }

    default public int getStepC() {
        return 0;
    }

    default public boolean resetA() {
        return false;
    }

    default public boolean resetB() {
        return false;
    }

    default public boolean resetC() {
        return false;
    }

    default public boolean isNavigating() {
        return false;
    }

    public static enum PlaceResult {
        SKIP,
        REJECT,
        STOP,
        ACCEPT,
        ACCEPT_STOP;

    }

    public static final class BlocksToPlace {
        public static final BlocksToPlace errored = BlocksToPlace.createEmpty();
        private final Predicate<ItemStack> predicate;
        private final Iterable<ItemStack> stacks;

        public static BlocksToPlace createEmpty() {
            return new BlocksToPlace(s -> false, Collections.emptyList());
        }

        public static BlocksToPlace create(ItemStack ... stacks) {
            return BlocksToPlace.create(Arrays.asList(stacks));
        }

        public static BlocksToPlace create(Iterable<ItemStack> stacks) {
            Predicate<ItemStack> predicate = null;
            for (ItemStack stack : stacks) {
                ItemStackPredicate p = ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT);
                if (predicate == null) {
                    predicate = p;
                    continue;
                }
                predicate = predicate.or(p);
            }
            return new BlocksToPlace(predicate, stacks);
        }

        public static BlocksToPlace create(Block block) {
            Item itemBlock = block.m_5456_();
            return BlocksToPlace.create(itemBlock);
        }

        public static BlocksToPlace create(Item item) {
            return new BlocksToPlace(ItemStackPredicate.from(item), Collections.singletonList(new ItemStack((ItemLike)item, 1)));
        }

        public static BlocksToPlace create(ItemStack itemStack) {
            return new BlocksToPlace(ItemStackPredicate.from(itemStack), Collections.singletonList(itemStack));
        }

        public static BlocksToPlace create(Predicate<ItemStack> predicate) {
            return new BlocksToPlace(predicate, null);
        }

        BlocksToPlace(Predicate<ItemStack> predicate, Iterable<ItemStack> stacks) {
            this.predicate = predicate;
            this.stacks = stacks;
        }

        @NotNull
        public Predicate<ItemStack> getPredicate() {
            return this.predicate;
        }

        @Nullable
        public Iterable<ItemStack> getStacks() {
            return this.stacks;
        }
    }
}

