/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.net;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.item.ItemConstructableTrigger;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SetChannelDataMessage
implements Packet<SetChannelDataMessage> {
    public static final Handler HANDLER = new Handler();
    private final List<Map.Entry<String, Integer>> data;
    private final InteractionHand hand;

    public SetChannelDataMessage(List<Map.Entry<String, Integer>> data, InteractionHand hand) {
        this.data = data;
        this.hand = hand;
    }

    public SetChannelDataMessage(ItemStack trigger, InteractionHand hand) {
        ArrayList<Map.Entry<String, Integer>> data = new ArrayList<Map.Entry<String, Integer>>();
        ChannelDataAccessor.iterateChannelData(trigger).forEach(data::add);
        this.data = data;
        this.hand = hand;
    }

    public PacketHandler<SetChannelDataMessage> getHandler() {
        return HANDLER;
    }

    public ResourceLocation getID() {
        return StructureLib.SET_CHANNEL_DATA;
    }

    private static class Handler
    implements PacketHandler<SetChannelDataMessage> {
        private Handler() {
        }

        public void encode(SetChannelDataMessage msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.data.size());
            for (Map.Entry<String, Integer> e : msg.data) {
                buf.m_130070_(e.getKey());
                buf.m_130130_(e.getValue().intValue());
            }
            buf.m_130068_((Enum)msg.hand);
        }

        public SetChannelDataMessage decode(FriendlyByteBuf buf) {
            int size = buf.m_130242_();
            ArrayList<Map.Entry<String, Integer>> data = new ArrayList<Map.Entry<String, Integer>>();
            for (int i = 0; i < size; ++i) {
                data.add((Map.Entry<String, Integer>)Pair.of((Object)buf.m_130277_(), (Object)buf.m_130242_()));
            }
            return new SetChannelDataMessage(data, (InteractionHand)buf.m_130066_(InteractionHand.class));
        }

        public PacketContext handle(SetChannelDataMessage msg) {
            return (sender, level) -> {
                ItemStack heldItem = sender.m_21120_(msg.hand);
                if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof ItemConstructableTrigger) {
                    ChannelDataAccessor.wipeChannelData(heldItem);
                    for (Map.Entry<String, Integer> e : msg.data) {
                        ChannelDataAccessor.setChannelData(heldItem, e.getKey(), e.getValue());
                    }
                } else {
                    StructureLib.LOGGER.warn("{} trying to set channel data on {}, which is not a hologram projector!", (Object)sender.m_5446_(), (Object)heldItem);
                }
            };
        }
    }
}

