/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.util.MiscUtils;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ChannelDataAccessor {
    private static final String SECONDARY_HINT_TAG = "channels";

    private ChannelDataAccessor() {
    }

    public static ItemStack withChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.m_41782_() && masterStack.m_41783_().m_128425_(SECONDARY_HINT_TAG, 10) && masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG).m_128425_(channel, 3))) {
            return masterStack;
        }
        ItemStack ret = new ItemStack((ItemLike)masterStack.m_41720_(), masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG).m_128451_(channel));
        ret.m_41751_(masterStack.m_41783_());
        return ret;
    }

    public static boolean hasSubChannel(ItemStack masterStack) {
        if (masterStack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        return masterStack.m_41782_() && masterStack.m_41783_().m_128425_(SECONDARY_HINT_TAG, 10);
    }

    public static boolean hasSubChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        return !channel.isEmpty() && masterStack.m_41782_() && masterStack.m_41783_().m_128425_(SECONDARY_HINT_TAG, 10) && masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG).m_128425_(channel, 3);
    }

    public static int getChannelData(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.m_41782_() && masterStack.m_41783_().m_128425_(SECONDARY_HINT_TAG, 10) && masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG).m_128425_(channel, 3))) {
            return masterStack.m_41613_();
        }
        return masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG).m_128451_(channel);
    }

    public static void setChannelData(ItemStack masterStack, String channel, int data) {
        CompoundTag main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (data <= 0) {
            throw new IllegalArgumentException();
        }
        if (masterStack.m_41783_() == null) {
            masterStack.m_41751_(new CompoundTag());
        }
        if (!(main = masterStack.m_41783_()).m_128425_(SECONDARY_HINT_TAG, 10)) {
            main.m_128365_(SECONDARY_HINT_TAG, (Tag)new CompoundTag());
        }
        main.m_128469_(SECONDARY_HINT_TAG).m_128405_(channel, data);
    }

    public static void unsetChannelData(ItemStack masterStack, String channel) {
        CompoundTag main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (masterStack.m_41783_() == null) {
            masterStack.m_41751_(new CompoundTag());
        }
        if (!(main = masterStack.m_41783_()).m_128425_(SECONDARY_HINT_TAG, 10)) {
            main.m_128365_(SECONDARY_HINT_TAG, (Tag)new CompoundTag());
        }
        CompoundTag tag = main.m_128469_(SECONDARY_HINT_TAG);
        tag.m_128473_(channel);
        if (tag.m_128456_()) {
            main.m_128473_(SECONDARY_HINT_TAG);
        }
        if (main.m_128456_()) {
            masterStack.m_41751_(null);
        }
    }

    public static void wipeChannelData(ItemStack masterStack) {
        if (masterStack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        if (masterStack.m_41783_() != null) {
            masterStack.m_41783_().m_128473_(SECONDARY_HINT_TAG);
        }
    }

    public static Stream<Map.Entry<String, Integer>> iterateChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return Stream.empty();
        }
        CompoundTag tag = masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG);
        return MiscUtils.getTagKeys(tag).stream().map(s -> new ImmutablePair(s, (Object)tag.m_128451_(s)));
    }

    public static int countChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return 0;
        }
        CompoundTag tag = masterStack.m_41783_().m_128469_(SECONDARY_HINT_TAG);
        return tag.m_128431_().size();
    }
}

