/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.ClientProxy;
import com.gtnewhorizon.structurelib.CommonProxy;
import com.gtnewhorizon.structurelib.StructureLibConfig;
import com.gtnewhorizon.structurelib.net.AlignmentMessage;
import com.gtnewhorizon.structurelib.net.ErrorHintParticleMessage;
import com.gtnewhorizon.structurelib.net.SetChannelDataMessage;
import com.gtnewhorizon.structurelib.net.UpdateHintParticleMessage;
import com.gtnewhorizon.structurelib.util.PlatformUtils;
import com.gtnewhorizon.structurelib.util.XSTR;
import com.teamresourceful.resourcefullib.common.networking.NetworkChannel;
import com.teamresourceful.resourcefullib.common.networking.base.NetworkDirection;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureLib {
    private static final String STRUCTURECOMPAT_MODID = "structurecompat";
    public static boolean DEBUG_MODE;
    public static boolean PANIC_MODE;
    public static final Logger LOGGER;
    public static final NetworkChannel CHANNEL;
    public static final ResourceLocation ALIGNMENT_QUERY;
    public static final ResourceLocation ALIGNMENT_DATA;
    public static final ResourceLocation UPDATE_HINT_PARTICLE;
    public static final ResourceLocation ERROR_HINT_PARTICLE;
    public static final ResourceLocation SET_CHANNEL_DATA;
    static CommonProxy proxy;
    public static final XSTR RANDOM;
    static StructureLib INSTANCE;
    static Object COMPAT;
    protected static CreativeModeTab creativeTab;

    public static void init() {
        CHANNEL.registerPacket(NetworkDirection.CLIENT_TO_SERVER, ALIGNMENT_QUERY, (PacketHandler)AlignmentMessage.AlignmentQuery.HANDLER, AlignmentMessage.AlignmentQuery.class);
        CHANNEL.registerPacket(NetworkDirection.SERVER_TO_CLIENT, ALIGNMENT_DATA, (PacketHandler)AlignmentMessage.AlignmentData.HANDLER, AlignmentMessage.AlignmentData.class);
        CHANNEL.registerPacket(NetworkDirection.SERVER_TO_CLIENT, UPDATE_HINT_PARTICLE, (PacketHandler)UpdateHintParticleMessage.HANDLER, UpdateHintParticleMessage.class);
        CHANNEL.registerPacket(NetworkDirection.SERVER_TO_CLIENT, ERROR_HINT_PARTICLE, (PacketHandler)ErrorHintParticleMessage.HANDLER, ErrorHintParticleMessage.class);
        CHANNEL.registerPacket(NetworkDirection.CLIENT_TO_SERVER, SET_CHANNEL_DATA, (PacketHandler)SetChannelDataMessage.HANDLER, SetChannelDataMessage.class);
        try {
            DEBUG_MODE = Boolean.parseBoolean(System.getProperty("structurelib.debug"));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public void preInit() {
        proxy = PlatformUtils.INSTANCE.isServer() ? new CommonProxy() : new ClientProxy();
        proxy.preInit();
        StructureLibConfig.init();
        StructureLib.init();
    }

    public static CreativeModeTab getCreativeTab() {
        return creativeTab;
    }

    public static void addClientSideChatMessages(String ... messages) {
        proxy.addClientSideChatMessages(messages);
    }

    public static Player getCurrentPlayer() {
        return proxy.getCurrentPlayer();
    }

    public static boolean isCurrentPlayer(Player player) {
        return proxy.isCurrentPlayer(player);
    }

    public static long getOverworldTime() {
        return proxy.getOverworldTime();
    }

    public static StructureLib instance() {
        return INSTANCE;
    }

    public CommonProxy proxy() {
        return proxy;
    }

    static {
        PANIC_MODE = Boolean.getBoolean("structurelib.panic");
        LOGGER = LogManager.getLogger((String)"StructureLib");
        CHANNEL = new NetworkChannel("structurelib", 0, "main");
        ALIGNMENT_QUERY = new ResourceLocation("structurelib", "alignment_query");
        ALIGNMENT_DATA = new ResourceLocation("structurelib", "alignment_data");
        UPDATE_HINT_PARTICLE = new ResourceLocation("structurelib", "update_hint_particle");
        ERROR_HINT_PARTICLE = new ResourceLocation("structurelib", "error_hint_particle");
        SET_CHANNEL_DATA = new ResourceLocation("structurelib", "set_channel_data");
        RANDOM = new XSTR();
    }
}

