/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.tree;

import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.gtreimagined.gtcore.tree.RubberTrunkPlacer;
import org.gtreimagined.gtlib.mixin.BiomeAccessor;
import org.gtreimagined.gtlib.util.TagUtils;

public class RubberTreeWorldGen {
    public static ResourceKey<PlacedFeature> TREE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree"));
    public static ResourceKey<PlacedFeature> TREE_SWAMP = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_swamp"));
    public static ResourceKey<PlacedFeature> TREE_JUNGLE = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_jungle"));
    public static ResourceKey<ConfiguredFeature<?, ?>> TREE_FEATURE_CONFIG = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_normal"));
    public static ResourceKey<ConfiguredFeature<?, ?>> TREE_FEATURE_SWAMP_CONFIG = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_swamp"));
    public static ResourceKey<ConfiguredFeature<?, ?>> TREE_FEATURE_JUNGLE_CONFIG = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_jungle"));
    public static final PlacementModifierType<RubberTreePlacementModifier> RUBBER_TREE_PLACEMENT_MODIFIER = () -> RubberTreePlacementModifier.CODEC;

    public static void init() {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256920_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_trunk_placer"), RubberTrunkPlacer.RUBBER);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256986_, (ResourceLocation)new ResourceLocation("gtcore", "rubber_tree_placement_modifier"), RUBBER_TREE_PLACEMENT_MODIFIER);
    }

    public static class RubberTreePlacementModifier
    extends PlacementModifier {
        public static final Codec<RubberTreePlacementModifier> CODEC = Codec.unit(RubberTreePlacementModifier::new);

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            BiomeAccessor biome = (BiomeAccessor)context.m_191831_().m_204166_(pos).m_203334_();
            if (context.m_191831_().m_204166_(pos).m_203656_(TagUtils.getBiomeTag((ResourceLocation)new ResourceLocation("gtcore", "is_invalid_rubber")))) {
                return Stream.empty();
            }
            float p = 0.15f;
            if (biome.getClimateSettings().f_47681_() > 0.8f) {
                p = 0.04f;
                if (biome.getClimateSettings().f_263819_()) {
                    p += 0.04f;
                }
            }
            float finalp = p;
            int i = 0;
            if (random.m_188500_() < (double)finalp) {
                i = random.m_188503_(1) + 1;
            }
            return IntStream.range(0, i).mapToObj(ix -> {
                int j = random.m_188503_(16) + pos.m_123341_();
                int k = random.m_188503_(16) + pos.m_123343_();
                return new BlockPos(j, context.m_191824_(Heightmap.Types.MOTION_BLOCKING, j, k), k);
            });
        }

        public PlacementModifierType<?> m_183327_() {
            return RUBBER_TREE_PLACEMENT_MODIFIER;
        }
    }
}

