/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtcore.BookRegistration;
import org.gtreimagined.gtcore.GTCoreCodeUtils;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineCoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBookShelf
extends BlockEntityMachine<BlockEntityBookShelf>
implements IFilterableHandler {
    public BlockEntityBookShelf(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new MachineItemHandler<BlockEntityBookShelf>(this){

            protected TrackedItemHandler<BlockEntityBookShelf> createTrackedHandler(SlotType<?> type, BlockEntityBookShelf tile) {
                if (type == SlotType.STORAGE) {
                    int count = tile.getMachineType().getCount(tile.getMachineTier(), type);
                    return new TrackedItemHandler((IGuiHandler)tile, type, count, type.output, type.input, type.tester, 1);
                }
                return super.createTrackedHandler(type, (BlockEntityMachine)tile);
            }
        });
        this.coverHandler.set(() -> new MachineCoverHandler<BlockEntityBookShelf>(this){

            public boolean placeCover(Player player, Direction side, ItemStack stack, ICover cover) {
                if (side == this.getTileFacing() || side == this.getTileFacing().m_122424_()) {
                    return false;
                }
                return super.placeCover(player, side, stack, cover);
            }
        });
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        double[] coords;
        Direction face = hit.m_82434_();
        Vec3 vec = hit.m_82450_();
        ITrackedHandler handler = this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE)).orElse(null);
        if ((face == this.getFacing() || face == this.getFacing().m_122424_()) && handler != null && (coords = GTCoreCodeUtils.getFacingCoordsClicked(face, vec.m_7096_() - (double)hit.m_82425_().m_123341_(), vec.m_7098_() - (double)hit.m_82425_().m_123342_(), vec.m_7094_() - (double)hit.m_82425_().m_123343_()))[0] >= (double)GTCoreCodeUtils.PX_P[1] && coords[0] <= (double)GTCoreCodeUtils.PX_N[1] && coords[1] >= (double)GTCoreCodeUtils.PX_P[1] && coords[1] <= (double)GTCoreCodeUtils.PX_N[1]) {
            int slot;
            if (face == this.getFacing() && this.switchBooks(player, slot = (coords[1] < (double)GTCoreCodeUtils.PX_P[8] ? 0 : 7) + (int)GTCoreCodeUtils.bind_(0L, 6L, (long)(8.0 * (coords[0] - (double)GTCoreCodeUtils.PX_P[1]))), handler, hand)) {
                return InteractionResult.SUCCESS;
            }
            if (face == this.getFacing().m_122424_() && this.switchBooks(player, slot = (coords[1] < (double)GTCoreCodeUtils.PX_P[8] ? 14 : 21) + (int)GTCoreCodeUtils.bind_(0L, 6L, (long)(8.0 * (coords[0] - (double)GTCoreCodeUtils.PX_P[1]))), handler, hand)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    private boolean switchBooks(Player player, int slot, ITrackedHandler handler, InteractionHand hand) {
        ItemStack current = handler.getStackInSlot(slot);
        if (!current.m_41619_()) {
            if (!player.m_6047_()) {
                // empty if block
            }
            if (player.m_36356_(current.m_41777_())) {
                handler.setStackInSlot(slot, ItemStack.f_41583_);
                this.sidedSync(true);
                return true;
            }
        } else {
            ItemStack held = player.m_21120_(hand);
            if (!held.m_41619_() && BookRegistration.getTextureMap().containsKey(held.m_41720_())) {
                handler.setStackInSlot(slot, Utils.ca((int)1, (ItemStack)held));
                held.m_41774_(1);
                this.sidedSync(true);
                return true;
            }
        }
        return false;
    }

    public boolean setFacing(Direction side) {
        if (this.coverHandler.map(c -> !c.get(side).isEmpty()).orElse(false).booleanValue()) {
            return false;
        }
        return super.setFacing(side);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.itemHandler.ifPresent(e -> {
            CompoundTag in = new CompoundTag();
            e.getAll().forEach((f, i) -> in.m_128365_(f.getId(), (Tag)this.serializeWithEmpty((IItemHandler)i, new CompoundTag())));
            nbt.m_128365_("it", (Tag)in);
        });
        return nbt;
    }

    public CompoundTag serializeWithEmpty(IItemHandler container, CompoundTag nbt) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < container.getSlots(); ++i) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            container.getStackInSlot(i).m_41739_(itemTag);
            itemTag.m_128405_("count", container.getStackInSlot(i).m_41613_());
            nbtTagList.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public boolean canPlayerOpenGui(Player playerEntity) {
        return playerEntity.m_7500_();
    }

    public boolean test(SlotType<?> slotType, int i, ItemStack itemStack) {
        return BookRegistration.getTextureMap().containsKey(itemStack.m_41720_());
    }

    public int getEnchantmentPowerBonus() {
        return this.itemHandler.map(i -> {
            int total = 0;
            ITrackedHandler handler = i.getHandler(SlotType.STORAGE);
            for (int j = 0; j < handler.getSlots(); ++j) {
                if (handler.getStackInSlot(j).m_204117_(GTCoreTags.BOOKS_ENCHANTED)) {
                    total += 2;
                }
                if (!handler.getStackInSlot(j).m_204117_(GTCoreTags.BOOKS_NORMAL)) continue;
                ++total;
            }
            return total;
        }).orElse(0);
    }
}

