package org.gtreimagined.gtcore.cover;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtcore.GTCore;
import org.gtreimagined.gtcore.blockentity.BlockEntityRedstoneWire;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;

public class CoverRepeater extends BaseCover {
    public CoverRepeater(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    @Override
    public boolean canPlace() {
        return source().getTile() instanceof BlockEntityRedstoneWire<?>;
    }

    @Override
    public void onPlace() {
        BlockEntityRedstoneWire<?> wire = (BlockEntityRedstoneWire<?>) source().getTile();
        wire.clearConnection(side);
    }

    @Override
    public boolean blockConnection(Direction side) {
        return true;
    }

    @Override
    public int getStrongPower() {
        BlockEntityRedstoneWire<?> wire = (BlockEntityRedstoneWire<?>) source().getTile();
        return wire.getRedstoneValue() > 0 ? 15 : 0;
    }

    @Override
    public int getWeakPower() {
        BlockEntityRedstoneWire<?> wire = (BlockEntityRedstoneWire<?>) source().getTile();
        return wire.getRedstoneValue() > 0 ? 15 : 0;
    }

    @Override
    public void setTextures(BiConsumer<String, Texture> texer) {
        BlockEntityRedstoneWire<?> wire = (BlockEntityRedstoneWire<?>) source().getTile();
        texer.accept("bottom", factory.getTextures().get(wire.getRedstoneValue() > 0 ? 0 : 1));
        texer.accept("top", factory.getTextures().get(wire.getRedstoneValue() > 0 ? 1 : 0));
        texer.accept("middle", factory.getTextures().get(1));
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        return new ResourceLocation(GTCore.ID + ":block/cover/" + this.getRenderId());
    }

    @Override
    public VoxelShape getShape(Direction side) throws ExecutionException {
        int config = 1 << side.get3DDataValue();
        BlockPipe<?> pipe = (BlockPipe<?>) GTCoreCables.WIRE_RED_ALLOY.getBlock(PipeSize.VTINY);
        return pipe.getPipeShapes().get(config, () -> pipe.makeShapes((short) config));
    }

    @Override
    public ResourceLocation getIdForCache() {
        return new ResourceLocation(GTCore.ID, "torches");
    }
}
