/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.client.model;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtcore.blockentity.BlockEntityBookShelf;
import org.gtreimagined.gtcore.client.BookSpriteMaps;
import org.gtreimagined.gtcore.client.model.BookShelfModel;
import org.gtreimagined.gtcore.client.model.IconModel;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.SimpleModelState;
import org.gtreimagined.gtlib.client.baked.GTBakedModel;
import org.gtreimagined.gtlib.client.quad.RetexturedBakedQuad;
import org.gtreimagined.gtlib.gui.SlotType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BookShelfBakedModel
extends GTBakedModel<BookShelfBakedModel> {
    BakedModel baseModel;

    public BookShelfBakedModel(BakedModel baseModel) {
        super(baseModel.m_6160_());
        this.baseModel = baseModel;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, @Nullable Direction direction, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        this.initBookQuads();
        ObjectArrayList quads = new ObjectArrayList();
        quads.addAll(ModelUtils.getQuadsFromBaked((BakedModel)this.baseModel, (BlockState)state, (Direction)direction, (RandomSource)rand, (BlockAndTintGetter)level, (BlockPos)pos));
        if (direction != Direction.SOUTH && direction != Direction.NORTH) {
            return quads;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof BlockEntityBookShelf)) {
            return quads;
        }
        BlockEntityBookShelf bookShelf = (BlockEntityBookShelf)be;
        int start = direction == Direction.SOUTH ? 0 : 14;
        int end = direction == Direction.SOUTH ? 14 : 28;
        for (int i = start; i < end; ++i) {
            Pair<TextureAtlasSprite, TextureAtlasSprite> spritePair;
            int finalI = i;
            ItemStack book = bookShelf.itemHandler.map(itemHandler -> itemHandler.getHandler(SlotType.STORAGE).getStackInSlot(finalI)).orElse(ItemStack.f_41583_);
            if (book.m_41619_() || !BookSpriteMaps.getSpriteMap().containsKey(book.m_41720_()) || (spritePair = BookSpriteMaps.getSpriteMap().get(book.m_41720_())) == null) continue;
            List<BakedQuad> list = BookShelfModel.BOOK_MODELS.get(i);
            for (BakedQuad quad : list) {
                TextureAtlasSprite sprite = quad.m_111306_() == Direction.SOUTH || quad.m_111306_() == Direction.NORTH ? (TextureAtlasSprite)spritePair.first() : (TextureAtlasSprite)spritePair.second();
                quads.add(new RetexturedBakedQuad(quad, sprite));
            }
        }
        return quads;
    }

    private void initBookQuads() {
        if (BookShelfModel.BOOK_MODELS == null) {
            BakedQuad quad;
            TextureAtlasSprite sprite;
            BlockElementFace face;
            Direction dir;
            Vector3f to;
            Vector3f from;
            ArrayList<BakedQuad> bakedQuads;
            int j;
            BlockElement element;
            int i;
            BookShelfModel.BOOK_MODELS = new ObjectArrayList();
            for (i = 0; i < BookShelfModel.BOOK_REFERENCE_SOUTH.size(); ++i) {
                element = BookShelfModel.BOOK_REFERENCE_SOUTH.get(i);
                for (j = 0; j < 7; ++j) {
                    bakedQuads = new ArrayList<BakedQuad>();
                    from = new Vector3f(element.f_111308_.x() + (float)(j * 2), element.f_111308_.y(), element.f_111308_.z());
                    to = new Vector3f(element.f_111309_.x() + (float)(j * 2), element.f_111309_.y(), element.f_111309_.z());
                    for (Map.Entry entry : element.f_111310_.entrySet()) {
                        dir = (Direction)entry.getKey();
                        face = (BlockElementFace)entry.getValue();
                        sprite = dir == Direction.SOUTH ? (TextureAtlasSprite)BookSpriteMaps.getSpriteMap().get(Items.f_42517_).first() : (TextureAtlasSprite)BookSpriteMaps.getSpriteMap().get(Items.f_42517_).second();
                        quad = IconModel.FACE_BAKERY.m_111600_(from, to, face, sprite, dir, (ModelState)new SimpleModelState(RenderHelper.faceRotation((Direction)Direction.SOUTH)), element.f_111311_, element.f_111312_, new ResourceLocation("gtcore", "bookshelf"));
                        bakedQuads.add(quad);
                    }
                    BookShelfModel.BOOK_MODELS.add(bakedQuads);
                }
            }
            for (i = 0; i < BookShelfModel.BOOK_REFERENCE_NORTH.size(); ++i) {
                element = BookShelfModel.BOOK_REFERENCE_NORTH.get(i);
                for (j = 0; j < 7; ++j) {
                    bakedQuads = new ArrayList();
                    from = new Vector3f(element.f_111308_.x() - (float)(j * 2), element.f_111308_.y(), element.f_111308_.z());
                    to = new Vector3f(element.f_111309_.x() - (float)(j * 2), element.f_111309_.y(), element.f_111309_.z());
                    for (Map.Entry entry : element.f_111310_.entrySet()) {
                        dir = (Direction)entry.getKey();
                        face = (BlockElementFace)entry.getValue();
                        sprite = dir == Direction.NORTH ? (TextureAtlasSprite)BookSpriteMaps.getSpriteMap().get(Items.f_42517_).first() : (TextureAtlasSprite)BookSpriteMaps.getSpriteMap().get(Items.f_42517_).second();
                        quad = IconModel.FACE_BAKERY.m_111600_(from, to, face, sprite, dir, (ModelState)new SimpleModelState(RenderHelper.faceRotation((Direction)Direction.SOUTH)), element.f_111311_, element.f_111312_, new ResourceLocation("gtcore", "bookshelf"));
                        bakedQuads.add(quad);
                    }
                    BookShelfModel.BOOK_MODELS.add(bakedQuads);
                }
            }
        }
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

