/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Redstone;
import org.gtreimagined.gtcore.block.BlockRedstoneWire;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.util.CodeUtils;

public class BlockEntityRedstoneWire<T extends RedstoneWire<T>>
extends BlockEntityPipe<T> {
    int state = 0;
    byte mReceived = (byte)6;
    byte mMode = 0;
    public long mRedstone = 0L;
    public boolean mConnectedToNonWire = true;
    public static final long MAX_RANGE = Integer.MAX_VALUE;
    public final long mLoss;

    public BlockEntityRedstoneWire(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.mLoss = Integer.MAX_VALUE / (long)((RedstoneWire)((Object)type)).getRange();
    }

    public boolean validate(Direction dir) {
        return true;
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.updateConnectionStatus();
        if (this.updateRedstone()) {
            BlockEntityRedstoneWire.doRedstoneUpdate(this);
        }
        if (this.mConnectedToNonWire) {
            for (Direction tSide : Direction.values()) {
                if (!this.connects(tSide) || this.getPipe(tSide) != null) continue;
                this.updateBlock(tSide);
            }
        }
    }

    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        if (this.f_58857_.m_8055_(neighbor).m_60734_() instanceof BlockRedstoneWire) {
            return;
        }
        this.updateConnectionStatus();
        if (this.updateRedstone()) {
            BlockEntityRedstoneWire.doRedstoneUpdate(this);
        }
    }

    public void toggleConnection(Direction side) {
        boolean oldConnectedToNonWire = this.mConnectedToNonWire;
        super.toggleConnection(side);
        if (this.mConnectedToNonWire || oldConnectedToNonWire) {
            this.updateBlock(side);
        }
    }

    public void setConnection(Direction side) {
        super.setConnection(side);
        this.updateConnectionStatus();
        if (this.updateRedstone()) {
            BlockEntityRedstoneWire.doRedstoneUpdate(this);
        }
    }

    public void clearConnection(Direction side) {
        super.clearConnection(side);
        this.updateConnectionStatus();
        if (this.updateRedstone()) {
            BlockEntityRedstoneWire.doRedstoneUpdate(this);
        }
    }

    public boolean onCoverUpdate(boolean remove, boolean hasNonEmpty, Direction side, ICover old, ICover stack) {
        boolean oldConnectedToNonWire = this.mConnectedToNonWire;
        boolean update = super.onCoverUpdate(remove, hasNonEmpty, side, old, stack);
        this.updateConnectionStatus();
        if (this.updateRedstone()) {
            BlockEntityRedstoneWire.doRedstoneUpdate(this);
        }
        if (this.mConnectedToNonWire || oldConnectedToNonWire) {
            this.updateBlock(side);
        }
        return update;
    }

    public Class<?> getCapClass() {
        return Redstone.class;
    }

    protected void register() {
    }

    protected boolean deregister() {
        return false;
    }

    public int getState() {
        return this.state;
    }

    public int getWeakPower(Direction side) {
        ICover cover = this.coverHandler.map(c -> c.get(side)).orElse(ICover.empty);
        if (cover.isNode()) {
            return cover.getWeakPower();
        }
        return this.getPower(side);
    }

    public int getStrongPower(Direction side) {
        ICover cover = this.coverHandler.map(c -> c.get(side)).orElse(ICover.empty);
        if (cover.isNode()) {
            return cover.getStrongPower();
        }
        return this.getPower(side);
    }

    private int getPower(Direction side) {
        if (side.m_122411_() == this.mReceived) {
            return 0;
        }
        BlockEntity neighbor = this.getCachedBlockEntity(side);
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_().m_121945_(side));
        if (neighbor instanceof BlockEntityRedstoneWire) {
            return 0;
        }
        boolean connects = this.connects(side);
        if (this.mRedstone <= 0L || !connects) {
            return 0;
        }
        return this.getVanillaRedstonePower() - (blockState.m_60713_(Blocks.f_50088_) || blockState.m_60838_((BlockGetter)this.f_58857_, this.m_58899_().m_121945_(side)) ? 1 : 0);
    }

    public int getComparatorInputOverride(byte aSide) {
        return CodeUtils.bind4((long)(this.mRedstone / Integer.MAX_VALUE));
    }

    public long getRedstoneLoss() {
        return this.mLoss;
    }

    public long getRedstoneValue() {
        return this.mRedstone;
    }

    public long getRedstoneMinusLoss() {
        return this.mRedstone - this.mLoss;
    }

    public int getVanillaRedstonePower() {
        return CodeUtils.bind4((long)CodeUtils.divup((long)this.mRedstone, (long)Integer.MAX_VALUE));
    }

    public void updateConnectionStatus() {
        this.mConnectedToNonWire = false;
        for (Direction tSide : Direction.values()) {
            if (!this.connects(tSide) && !this.coverHandler.map(c -> c.get(tSide).getWeakPower() >= 0).orElse(false).booleanValue() || this.getCachedBlockEntity(tSide) instanceof BlockEntityRedstoneWire) continue;
            this.mConnectedToNonWire = true;
        }
    }

    public long getRedstoneAtSide(int aSide) {
        if (aSide < 0 || aSide > 5) {
            return 0L;
        }
        Direction side = Direction.m_122376_((int)aSide);
        if (!this.connects(side)) {
            return 0L;
        }
        BlockEntity tDelegator = this.getCachedBlockEntity(side);
        if (tDelegator instanceof BlockEntityRedstoneWire) {
            BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)tDelegator;
            return this.connects(side) && wire.connects(side.m_122424_()) ? wire.getRedstoneMinusLoss() : 0L;
        }
        BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_121945_(side));
        int redstoneLevel = this.f_58857_.m_277185_(this.m_58899_().m_121945_(side), side);
        return Integer.MAX_VALUE * (long)redstoneLevel - (((RedstoneWire)this.getPipeType()).getRange() == 1 && state.m_60734_() != Blocks.f_50088_ ? 0L : this.mLoss);
    }

    private void updateBlock(Direction side) {
        this.m_58904_().markAndNotifyBlock(this.m_58899_(), this.m_58904_().m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 512);
        BlockPos neighbor = this.m_58899_().m_121945_(side);
        BlockState neighborState = this.m_58904_().m_8055_(neighbor);
        this.m_58904_().m_46590_(neighbor, neighborState.m_60734_(), side.m_122424_());
    }

    public boolean updateRedstone() {
        long oRedstone = this.mRedstone;
        long tRedstone = (long)this.mMode * Integer.MAX_VALUE - this.mLoss;
        byte oReceived = this.mReceived;
        this.mRedstone = this.getRedstoneAtSide(oReceived);
        if (this.mRedstone <= tRedstone) {
            this.mRedstone = tRedstone;
            this.mReceived = (byte)6;
        }
        ArrayList<Direction> sidesToUpdate = new ArrayList<Direction>();
        for (Direction tSide : Direction.values()) {
            if (!(this.m_58904_().m_8055_(this.m_58899_().m_121945_(tSide)).m_60734_() instanceof BlockRedstoneWire)) {
                sidesToUpdate.add(tSide);
            }
            if (tSide.m_122411_() == oReceived || (tRedstone = this.getRedstoneAtSide(tSide.m_122411_())) <= this.mRedstone) continue;
            this.mRedstone = tRedstone;
            this.mReceived = (byte)tSide.m_122411_();
        }
        if (this.mRedstone != oRedstone) {
            this.sidedSync(true);
            if (((RedstoneWire)this.type).isEmitsLight() && this.f_58857_ != null && this.size == PipeSize.VTINY) {
                int lightLevel = (Integer)this.m_58900_().m_61143_((Property)BlockRedstoneWire.LIGHT);
                if (this.getVanillaRedstonePower() != lightLevel) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockRedstoneWire.LIGHT, (Comparable)Integer.valueOf(this.getVanillaRedstonePower())), 0);
                }
            }
            if (this.mConnectedToNonWire) {
                for (Direction tSide : sidesToUpdate) {
                    this.updateBlock(tSide);
                }
            }
            return true;
        }
        return false;
    }

    public static void doRedstoneUpdate(BlockEntityRedstoneWire<?> aTileEntity) {
        HashSet tSetUpdating = new HashSet(List.of(aTileEntity));
        HashSet<BlockEntityRedstoneWire> tSetNext = new HashSet<BlockEntityRedstoneWire>();
        while (!tSetUpdating.isEmpty()) {
            for (BlockEntityRedstoneWire<?> tTileEntity : tSetUpdating) {
                for (Direction tSide : Direction.values()) {
                    BlockEntityRedstoneWire wire;
                    BlockEntity tDelegator;
                    if (!tTileEntity.connects(tSide) || !((tDelegator = tTileEntity.getCachedBlockEntity(tSide)) instanceof BlockEntityRedstoneWire) || !(wire = (BlockEntityRedstoneWire)tDelegator).connects(tSide.m_122424_()) || !wire.updateRedstone()) continue;
                    tSetNext.add(wire);
                }
            }
            tSetUpdating.clear();
            tSetUpdating.addAll(tSetNext);
            tSetNext.clear();
        }
    }

    public void setMode(int mode) {
        byte oldMode = this.mMode;
        this.mMode = CodeUtils.bind4((long)mode);
        if (oldMode != this.mMode) {
            this.updateConnectionStatus();
            if (this.updateRedstone()) {
                BlockEntityRedstoneWire.doRedstoneUpdate(this);
            }
        }
    }

    public List<String> getInfo(boolean simple) {
        List info = super.getInfo(simple);
        if (!simple) {
            info.add("Internal redstone value " + this.mRedstone);
        }
        info.add("Redstone power: " + this.getVanillaRedstonePower());
        return info;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("mRedstone", this.mRedstone);
        tag.m_128344_("mMode", this.mMode);
        tag.m_128344_("mReceived", this.mReceived);
        tag.m_128379_("mConnectedToNonWire", this.mConnectedToNonWire);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mRedstone = tag.m_128454_("mRedstone");
        this.mMode = tag.m_128445_("mMode");
        this.mReceived = tag.m_128445_("mReceived");
        this.mConnectedToNonWire = tag.m_128471_("mConnectedToNonWire");
        if (this.m_58904_() != null && this.isClientSide()) {
            this.coverHandler.ifPresent(c -> c.coverTexturer.forEach((d, t) -> t.invalidate()));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        updateTag.m_128356_("mRedstone", this.mRedstone);
        updateTag.m_128379_("mConnectedToNonWire", this.mConnectedToNonWire);
        return updateTag;
    }
}

